/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.functions.DatacenterToLocation;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.compute.functions.ProductItemsToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToNodeMetadata;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.compute.strategy.SoftLayerComputeServiceAdapter;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.jclouds.softlayer.domain.ProductPackage;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.features.AccountClient;
import org.jclouds.softlayer.features.ProductPackageClient;
import org.jclouds.softlayer.predicates.ProductPackagePredicates;

public class SoftLayerComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter> {
    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter>>(){}).to(SoftLayerComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<VirtualGuest, NodeMetadata>>(){}).to(VirtualGuestToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<ProductItem, Image>>(){}).to(ProductItemToImage.class);
        this.bind(new TypeLiteral<Function<Iterable<ProductItem>, Hardware>>(){}).to(ProductItemsToHardware.class);
        this.bind(new TypeLiteral<Function<Datacenter, Location>>(){}).to(DatacenterToLocation.class);
        this.bind(TemplateOptions.class).to(SoftLayerTemplateOptions.class);
        this.install(new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<VirtualGuest, Iterable<ProductItem>, ProductItem, Datacenter>(){});
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<ProductPackage> getProductPackage(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, final SoftLayerClient client, final @Named(value="jclouds.softlayer.virtualguest.package-name") String virtualGuestPackageName) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, new Supplier<ProductPackage>(){

            @Override
            public ProductPackage get() {
                AccountClient accountClient = client.getAccountClient();
                ProductPackageClient productPackageClient = client.getProductPackageClient();
                ProductPackage p = Iterables.find(accountClient.getActivePackages(), ProductPackagePredicates.named(virtualGuestPackageName));
                return productPackageClient.getProductPackage(p.getId());
            }

            public String toString() {
                return Objects.toStringHelper(client).add("method", "accountClient.getActivePackages").add("method", "productPackageClient.getProductPackage").toString();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    public Iterable<ProductItemPrice> prices(@Named(value="jclouds.softlayer.virtualguest.prices") String prices) {
        return Iterables.transform(Splitter.on(',').split(Preconditions.checkNotNull(prices, "prices")), new Function<String, ProductItemPrice>(){

            @Override
            public ProductItemPrice apply(String arg0) {
                return ((ProductItemPrice.Builder)ProductItemPrice.builder().id(Integer.parseInt(arg0))).build();
            }
        });
    }
}

