/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.functions;

import com.google.common.base.Function;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.openstack.v2_0.domain.Extension;

@Singleton
public class ExtensionToNameSpace
implements Function<Extension, URI> {
    private final Provider<UriBuilder> uriBuilders;

    @Inject
    public ExtensionToNameSpace(Provider<UriBuilder> uriBuilders) {
        this.uriBuilders = uriBuilders;
    }

    @Override
    public URI apply(Extension input) {
        return this.uriBuilders.get().uri(input.getNamespace()).scheme("http").build(new Object[0]);
    }

    public String toString() {
        return "extensionToURI()";
    }
}

