/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateVolumeSnapshotOptions
implements MapBinder {
    public static final CreateVolumeSnapshotOptions NONE = new CreateVolumeSnapshotOptions();
    @Inject
    private BindToJsonPayload jsonBinder;
    private String name;
    private String description;
    private boolean force = false;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap<String, Object> data = Maps.newHashMap(postParams);
        if (this.name != null) {
            data.put("display_name", this.name);
        }
        if (this.description != null) {
            data.put("display_description", this.description);
        }
        if (this.force) {
            data.put("force", "true");
        }
        return this.jsonBinder.bindToRequest(request, ImmutableMap.of("snapshot", data));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("CreateSnapshot is a POST operation");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CreateVolumeSnapshotOptions)) {
            return false;
        }
        CreateVolumeSnapshotOptions other = (CreateVolumeSnapshotOptions)CreateVolumeSnapshotOptions.class.cast(object);
        return Objects.equal(this.name, other.name) && Objects.equal(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.description);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("name", this.name).add("description", this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    public CreateVolumeSnapshotOptions name(String name) {
        this.name = name;
        return this;
    }

    public CreateVolumeSnapshotOptions description(String description) {
        this.description = description;
        return this;
    }

    public CreateVolumeSnapshotOptions force() {
        this.force = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isForce() {
        return this.force;
    }

    public static class Builder {
        public static CreateVolumeSnapshotOptions name(String name) {
            return new CreateVolumeSnapshotOptions().name(name);
        }

        public static CreateVolumeSnapshotOptions description(String description) {
            return new CreateVolumeSnapshotOptions().description(description);
        }

        public static CreateVolumeSnapshotOptions force() {
            return new CreateVolumeSnapshotOptions().force();
        }
    }
}

