/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.FlavorInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ImageInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.predicates.ImagePredicates;

public class NovaComputeServiceAdapter
implements ComputeServiceAdapter<ServerInZone, FlavorInZone, ImageInZone, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    protected final Supplier<Set<String>> zoneIds;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    protected final LoadingCache<ZoneAndName, KeyPair> keyPairCache;

    @Inject
    public NovaComputeServiceAdapter(NovaApi novaApi, @Zone Supplier<Set<String>> zoneIds, RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, LoadingCache<ZoneAndName, KeyPair> keyPairCache) {
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.zoneIds = Preconditions.checkNotNull(zoneIds, "zoneIds");
        this.removeFloatingIpFromNodeAndDeallocate = Preconditions.checkNotNull(removeFloatingIpFromNodeAndDeallocate, "removeFloatingIpFromNodeAndDeallocate");
        this.keyPairCache = Preconditions.checkNotNull(keyPairCache, "keyPairCache");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInZone> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
        NovaTemplateOptions templateOptions = template.getOptions().as(NovaTemplateOptions.class);
        CreateServerOptions options = new CreateServerOptions();
        options.metadata(ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue(template.getOptions()));
        if (templateOptions.getSecurityGroupNames().isPresent()) {
            options.securityGroupNames((Iterable<String>)templateOptions.getSecurityGroupNames().get());
        }
        options.userData(templateOptions.getUserData());
        Optional<Object> privateKey = Optional.absent();
        if (templateOptions.getKeyPairName() != null) {
            options.keyPairName(templateOptions.getKeyPairName());
            KeyPair keyPair = (KeyPair)this.keyPairCache.getIfPresent(ZoneAndName.fromZoneAndName(template.getLocation().getId(), templateOptions.getKeyPairName()));
            if (keyPair != null && keyPair.getPrivateKey() != null) {
                privateKey = Optional.of(keyPair.getPrivateKey());
                credentialsBuilder.privateKey((String)privateKey.get());
            }
        }
        String zoneId = template.getLocation().getId();
        String imageId = template.getImage().getProviderId();
        String flavorId = template.getHardware().getProviderId();
        this.logger.debug(">> creating new server zone(%s) name(%s) image(%s) flavor(%s) options(%s)", zoneId, name, imageId, flavorId, options);
        ServerCreated lightweightServer = this.novaApi.getServerApiForZone(zoneId).create(name, imageId, flavorId, options);
        Server server = this.novaApi.getServerApiForZone(zoneId).get(lightweightServer.getId());
        this.logger.trace("<< server(%s)", server.getId());
        ServerInZone serverInZone = new ServerInZone(server, zoneId);
        if (!privateKey.isPresent()) {
            credentialsBuilder.password(lightweightServer.getAdminPass());
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials<ServerInZone>(serverInZone, serverInZone.slashEncode(), credentialsBuilder.build());
    }

    @Override
    public Iterable<FlavorInZone> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : this.zoneIds.get()) {
            builder.addAll(Iterables.transform(this.novaApi.getFlavorApiForZone(zoneId).listInDetail().concat(), new Function<Flavor, FlavorInZone>(){

                @Override
                public FlavorInZone apply(Flavor arg0) {
                    return new FlavorInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    @Override
    public Iterable<ImageInZone> listImages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set<String> zones = this.zoneIds.get();
        Preconditions.checkState(zones.size() > 0, "no zones found in supplier %s", this.zoneIds);
        for (final String zoneId : zones) {
            ImmutableSet<? extends Image> images = this.novaApi.getImageApiForZone(zoneId).listInDetail().concat().toImmutableSet();
            if (images.size() == 0) {
                this.logger.debug("no images found in zone %s", zoneId);
                continue;
            }
            Iterable<Image> active = Iterables.filter(images, ImagePredicates.statusEquals(Image.Status.ACTIVE));
            if (images.size() == 0) {
                this.logger.debug("no images with status active in zone %s; non-active: %s", zoneId, Iterables.transform(active, new Function<Image, String>(){

                    @Override
                    public String apply(Image input) {
                        return Objects.toStringHelper("").add("id", input.getId()).add("status", (Object)input.getStatus()).toString();
                    }
                }));
                continue;
            }
            builder.addAll(Iterables.transform(active, new Function<Image, ImageInZone>(){

                @Override
                public ImageInZone apply(Image arg0) {
                    return new ImageInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    @Override
    public Iterable<ServerInZone> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : this.zoneIds.get()) {
            builder.addAll(this.novaApi.getServerApiForZone(zoneId).listInDetail().concat().transform(new Function<Server, ServerInZone>(){

                @Override
                public ServerInZone apply(Server arg0) {
                    return new ServerInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    @Override
    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    @Override
    public ServerInZone getNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        Server server = this.novaApi.getServerApiForZone(zoneAndId.getZone()).get(zoneAndId.getId());
        return server == null ? null : new ServerInZone(server, zoneAndId.getZone());
    }

    @Override
    public ImageInZone getImage(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        Image image = this.novaApi.getImageApiForZone(zoneAndId.getZone()).get(zoneAndId.getId());
        return image == null ? null : new ImageInZone(image, zoneAndId.getZone());
    }

    @Override
    public void destroyNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaApi.getFloatingIPExtensionForZone(zoneAndId.getZone()).isPresent()) {
            try {
                this.removeFloatingIpFromNodeAndDeallocate.apply(zoneAndId);
            }
            catch (RuntimeException e) {
                this.logger.warn(e, "<< error removing and deallocating ip from node(%s): %s", id, e.getMessage());
            }
        }
        this.novaApi.getServerApiForZone(zoneAndId.getZone()).delete(zoneAndId.getId());
    }

    @Override
    public void rebootNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        this.novaApi.getServerApiForZone(zoneAndId.getZone()).reboot(zoneAndId.getId(), RebootType.HARD);
    }

    @Override
    public void resumeNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).isPresent()) {
            this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).get().resume(zoneAndId.getId());
        }
        throw new UnsupportedOperationException("resume requires installation of the Admin Actions extension");
    }

    @Override
    public void suspendNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).isPresent()) {
            this.novaApi.getServerAdminExtensionForZone(zoneAndId.getZone()).get().suspend(zoneAndId.getId());
        }
        throw new UnsupportedOperationException("suspend requires installation of the Admin Actions extension");
    }
}

