/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.jclouds.openstack.nova.domain.AbsoluteLimit;
import org.jclouds.openstack.nova.domain.RateLimit;

public class Limits {
    private final List<RateLimit> rate;
    private final List<AbsoluteLimit> absolute;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLimits(this);
    }

    @ConstructorProperties(value={"rate", "absolute"})
    protected Limits(List<RateLimit> rate, List<AbsoluteLimit> absolute) {
        this.rate = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(rate, "rate"));
        this.absolute = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(absolute, "absolute"));
    }

    public List<RateLimit> getRate() {
        return this.rate;
    }

    public List<AbsoluteLimit> getAbsolute() {
        return this.absolute;
    }

    public int hashCode() {
        return Objects.hashCode(this.rate, this.absolute);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limits that = (Limits)Limits.class.cast(obj);
        return Objects.equal(this.rate, that.rate) && Objects.equal(this.absolute, that.absolute);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("rate", this.rate).add("absolute", this.absolute);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected List<RateLimit> rate = ImmutableList.of();
        protected List<AbsoluteLimit> absolute = ImmutableList.of();

        protected abstract T self();

        public T rate(List<RateLimit> rate) {
            this.rate = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(rate, "rate"));
            return this.self();
        }

        public T rate(RateLimit ... in) {
            return this.rate(ImmutableList.copyOf(in));
        }

        public T absolute(List<AbsoluteLimit> absolute) {
            this.absolute = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(absolute, "absolute"));
            return this.self();
        }

        public T absolute(AbsoluteLimit ... in) {
            return this.absolute(ImmutableList.copyOf(in));
        }

        public Limits build() {
            return new Limits(this.rate, this.absolute);
        }

        public T fromLimits(Limits in) {
            return ((Builder)this.rate(in.getRate())).absolute(in.getAbsolute());
        }
    }
}

