/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.filters;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.openstack.keystone.v2_0.config.Authentication;

@Singleton
public class AuthenticateRequest
implements HttpRequestFilter {
    private final Supplier<String> authTokenProvider;

    @Inject
    public AuthenticateRequest(@Authentication Supplier<String> authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("X-Auth-Token", this.authTokenProvider.get())).build();
    }
}

