/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.config;

import com.google.common.base.Function;
import com.google.inject.TypeLiteral;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.config.JCloudsNativeComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.nodepool.NodePoolApiMetadata;
import org.jclouds.nodepool.NodePoolComputeServiceAdapter;
import org.jclouds.nodepool.NodePoolComputeServiceContext;
import org.jclouds.nodepool.internal.JsonNodeMetadataStore;
import org.jclouds.nodepool.internal.NodeMetadataStore;

public class NodePoolComputeServiceContextModule
extends JCloudsNativeComputeServiceAdapterContextModule {
    public NodePoolComputeServiceContextModule() {
        super(NodePoolComputeServiceAdapter.class);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(NodeMetadataStore.class).to(JsonNodeMetadataStore.class);
        this.bind(ApiMetadata.class).to(NodePoolApiMetadata.class);
        this.bind(ComputeServiceContext.class).to(NodePoolComputeServiceContext.class);
        this.install(new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<NodeMetadata, Hardware, Image, Location>(){});
    }

    @Override
    protected void bindCredentialsOverriderFunction() {
        this.bind(new TypeLiteral<Function<Template, LoginCredentials>>(){}).to(NullCredentialsOverrider.class);
    }

    private static class NullCredentialsOverrider
    implements Function<Template, LoginCredentials> {
        private NullCredentialsOverrider() {
        }

        @Override
        @Nullable
        public LoginCredentials apply(@Nullable Template input) {
            return null;
        }
    }
}

