/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Exposed;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.lifecycle.Closer;
import org.jclouds.nodepool.Backend;
import org.jclouds.nodepool.config.BindJcloudsModules;

public class BindInputStreamToFilesystemBlobStore
extends BindJcloudsModules {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @Exposed
    @Named(value="METADATA")
    protected Supplier<Map<String, InputStream>> provideInputStreamMapFromBlobStore(Supplier<BlobStoreContext> in, final @Named(value="jclouds.nodepool.metadata-container") String container) {
        return Suppliers.ofInstance(new Function<BlobStoreContext, Map<String, InputStream>>(){

            @Override
            public Map<String, InputStream> apply(BlobStoreContext input) {
                input.getBlobStore().createContainerInLocation(null, container);
                return input.createInputStreamMap(container);
            }
        }.apply(in.get()));
    }

    @Provides
    @Singleton
    protected Supplier<BlobStoreContext> makeBlobStoreContext(final @Named(value="jclouds.nodepool.basedir") String basedir, final @Backend Set<Module> modules, final Closer closer) {
        final Properties overrides = new Properties();
        overrides.setProperty("jclouds.filesystem.basedir", basedir);
        return Suppliers.memoize(new Supplier<BlobStoreContext>(){

            @Override
            public BlobStoreContext get() {
                new File(basedir).mkdirs();
                BlobStoreContext returnVal = ContextBuilder.newBuilder("filesystem").overrides(overrides).modules(modules).buildView(BlobStoreContext.class);
                closer.addToClose(returnVal);
                return returnVal;
            }
        });
    }
}

