/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.nodepool.NodePoolComputeServiceContext;
import org.jclouds.nodepool.config.BindBackendComputeService;
import org.jclouds.nodepool.config.BindInputStreamToFilesystemBlobStore;
import org.jclouds.nodepool.config.NodePoolComputeServiceContextModule;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class NodePoolApiMetadata
extends BaseApiMetadata {
    private static final long serialVersionUID = -2778027403592717115L;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)Builder.class.cast(NodePoolApiMetadata.builder().fromApiMetadata(this));
    }

    public NodePoolApiMetadata() {
        super(NodePoolApiMetadata.builder());
    }

    protected NodePoolApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.nodepool.backend-group", "nodepool");
        properties.setProperty("jclouds.nodepool.metadata-container", "nodes");
        properties.setProperty("jclouds.nodepool.backend-modules", "org.jclouds.logging.slf4j.config.SLF4JLoggingModule,org.jclouds.sshj.config.SshjSshClientModule");
        properties.setProperty("jclouds.nodepool.max-size", "10");
        properties.setProperty("jclouds.nodepool.min-size", "5");
        properties.setProperty("jclouds.nodepool.remove-destroyed", "true");
        if (new File(System.getProperty("user.home") + "/.ssh/id_rsa").exists()) {
            properties.setProperty("jclouds.nodepool.admin-access", "adminUsername=" + System.getProperty("user.name") + ",adminPrivateKeyFile=" + System.getProperty("user.home") + "/.ssh/id_rsa");
        }
        return properties;
    }

    public static class Builder
    extends BaseApiMetadata.Builder {
        protected Builder() {
            ((BaseApiMetadata.Builder)((BaseApiMetadata.Builder)this.id("nodepool").name("node pool provider wrapper").identityName("backend identity").endpointName("backend endpoint").defaultEndpoint("fixme").documentation(URI.create("http://www.jclouds.org/documentation/userguide/compute")).view(NodePoolComputeServiceContext.class)).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(NodePoolComputeServiceContextModule.class)).add(BindInputStreamToFilesystemBlobStore.class)).add(BindBackendComputeService.class)).build()))).defaultProperties(NodePoolApiMetadata.defaultProperties());
        }

        @Override
        public NodePoolApiMetadata build() {
            return new NodePoolApiMetadata(this);
        }
    }
}

