/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.karaf.core.BlobStoreProviderOrApiListener;
import org.jclouds.karaf.core.BlobStoreProviderOrApiRegistry;
import org.jclouds.karaf.services.InvalidConfigurationException;
import org.jclouds.karaf.services.ServiceFactorySupport;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreServiceFactory
extends ServiceFactorySupport
implements BlobStoreProviderOrApiListener,
BlobStoreProviderOrApiRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreServiceFactory.class);
    private final BundleContext bundleContext;

    public BlobStoreServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "BlobStore Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration;
        block22: {
            ContextBuilder builder;
            BlobStoreContext context;
            String endpoint;
            String credential;
            String identity;
            String id;
            Properties props;
            block24: {
                ServiceRegistration oldRegistration2;
                ApiMetadata apiMetadata;
                ProviderMetadata providerMetadata;
                block23: {
                    ServiceRegistration oldRegistration3;
                    newRegistration = null;
                    this.lock.tryLock();
                    if (properties == null) break block22;
                    props = new Properties();
                    Enumeration e = properties.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        Object val = properties.get(key);
                        props.put(key, val);
                    }
                    String provider = (String)properties.get("provider");
                    String api = (String)properties.get("api");
                    providerMetadata = null;
                    apiMetadata = null;
                    if (!Strings.isNullOrEmpty(provider) && this.installedProviders.containsKey(provider)) {
                        providerMetadata = (ProviderMetadata)this.installedProviders.get(provider);
                        BlobStoreServiceFactory.validate(providerMetadata, properties);
                        break block23;
                    }
                    if (!Strings.isNullOrEmpty(api) && this.installedApis.containsKey(api)) {
                        apiMetadata = (ApiMetadata)this.installedApis.get(api);
                        BlobStoreServiceFactory.validate(apiMetadata, properties);
                        break block23;
                    }
                    if (!Strings.isNullOrEmpty(provider)) {
                        this.providerPids.put(provider, pid);
                    }
                    if (!Strings.isNullOrEmpty(api)) {
                        this.apiPids.put(api, pid);
                    }
                    this.pendingPids.put(pid, properties);
                    LOGGER.warn("Provider {} or Api {} is not currently installed. Service will resume once the the provider is installed.", (Object)provider, (Object)api);
                    ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                    if (oldRegistration3 != null) {
                        System.out.println("Unregistering BlobStore " + pid);
                        oldRegistration3.unregister();
                    }
                    if (!this.lock.isHeldByCurrentThread()) return;
                    this.lock.unlock();
                    return;
                }
                id = (String)properties.get("name");
                identity = (String)properties.remove("identity");
                credential = (String)properties.remove("credential");
                endpoint = (String)properties.get("endpoint");
                context = null;
                builder = null;
                if (providerMetadata != null) {
                    builder = ContextBuilder.newBuilder(providerMetadata);
                    break block24;
                }
                if (apiMetadata != null) {
                    builder = ContextBuilder.newBuilder(apiMetadata);
                    break block24;
                }
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration2 != null) {
                    System.out.println("Unregistering BlobStore " + pid);
                    oldRegistration2.unregister();
                }
                if (!this.lock.isHeldByCurrentThread()) return;
                this.lock.unlock();
                return;
            }
            try {
                if (!Strings.isNullOrEmpty(endpoint)) {
                    builder = builder.endpoint(endpoint);
                }
                context = builder.name(id).credentials(identity, credential).modules(ImmutableSet.of(new Log4JLoggingModule())).overrides(props).build(BlobStoreContext.class);
                BlobStore blobStore = context.getBlobStore();
                newRegistration = this.bundleContext.registerService(BlobStore.class.getName(), (Object)blobStore, properties);
                if (!this.pendingPids.containsKey(pid)) break block22;
                this.activePids.put(pid, this.pendingPids.remove(pid));
            }
            catch (InvalidConfigurationException ex) {
                ServiceRegistration oldRegistration4;
                LOGGER.warn("Invalid configuration: {}", (Object)ex.getMessage());
                ServiceRegistration serviceRegistration = oldRegistration4 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration4 != null) {
                    System.out.println("Unregistering BlobStore " + pid);
                    oldRegistration4.unregister();
                }
                if (!this.lock.isHeldByCurrentThread()) return;
                this.lock.unlock();
                return;
            }
            catch (Exception ex2) {
                ServiceRegistration oldRegistration5;
                LOGGER.error("Error creating blobstore service.", ex2);
                ServiceRegistration serviceRegistration = oldRegistration5 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                {
                    catch (Throwable throwable) {
                        ServiceRegistration oldRegistration6;
                        ServiceRegistration serviceRegistration2 = oldRegistration6 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                        if (oldRegistration6 != null) {
                            System.out.println("Unregistering BlobStore " + pid);
                            oldRegistration6.unregister();
                        }
                        if (!this.lock.isHeldByCurrentThread()) throw throwable;
                        this.lock.unlock();
                        throw throwable;
                    }
                }
                if (oldRegistration5 != null) {
                    System.out.println("Unregistering BlobStore " + pid);
                    oldRegistration5.unregister();
                }
                if (!this.lock.isHeldByCurrentThread()) return;
                this.lock.unlock();
                return;
            }
        }
        ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        if (oldRegistration != null) {
            System.out.println("Unregistering BlobStore " + pid);
            oldRegistration.unregister();
        }
        if (!this.lock.isHeldByCurrentThread()) return;
        this.lock.unlock();
        return;
    }
}

