/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.core;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.karaf.core.NodeListener;
import org.jclouds.scriptbuilder.domain.Statement;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceEventProxy
implements ComputeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceEventProxy.class);
    private BundleContext bundleContext;
    private ComputeService computeService;
    private ServiceTracker listenerTracker;

    public ComputeServiceEventProxy(BundleContext bundleContext, ComputeService computeService) {
        this.bundleContext = bundleContext;
        this.computeService = computeService;
        this.listenerTracker = new ServiceTracker(bundleContext, NodeListener.class.getName(), null);
        this.listenerTracker.open();
    }

    private List<? extends NodeListener> getNodeListeners() {
        LinkedList<NodeListener> listeners = new LinkedList<NodeListener>();
        try {
            listeners.addAll(Arrays.asList((NodeListener[])this.listenerTracker.getServices()));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not lookup node listeners. Listeners will not receive the last event.");
        }
        return listeners;
    }

    @Override
    public ComputeServiceContext getContext() {
        return this.computeService.getContext();
    }

    @Override
    public TemplateBuilder templateBuilder() {
        return this.computeService.templateBuilder();
    }

    @Override
    public TemplateOptions templateOptions() {
        return this.computeService.templateOptions();
    }

    @Override
    public Set<? extends Hardware> listHardwareProfiles() {
        return this.computeService.listHardwareProfiles();
    }

    @Override
    public Set<? extends Image> listImages() {
        return this.computeService.listImages();
    }

    @Override
    public Set<? extends ComputeMetadata> listNodes() {
        return this.computeService.listNodes();
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return this.computeService.listAssignableLocations();
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Set<? extends NodeMetadata> metadata = this.computeService.createNodesInGroup(group, count, template);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata nodeMetadata : metadata) {
                    nodeListener.nodeCreated(nodeMetadata);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", ex);
        }
        return metadata;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        Set<? extends NodeMetadata> metadata = this.computeService.createNodesInGroup(group, count, templateOptions);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata nodeMetadata : metadata) {
                    nodeListener.nodeCreated(nodeMetadata);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", ex);
        }
        return metadata;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) throws RunNodesException {
        Set<? extends NodeMetadata> metadata = this.computeService.createNodesInGroup(group, count);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata nodeMetadata : metadata) {
                    nodeListener.nodeCreated(nodeMetadata);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", ex);
        }
        return metadata;
    }

    @Override
    public void resumeNode(String id) {
        this.computeService.resumeNode(id);
    }

    @Override
    public void resumeNodesMatching(Predicate<NodeMetadata> filter) {
        this.computeService.resumeNodesMatching(filter);
    }

    @Override
    public void suspendNode(String id) {
        this.computeService.suspendNode(id);
    }

    @Override
    public void suspendNodesMatching(Predicate<NodeMetadata> filter) {
        this.computeService.suspendNodesMatching(filter);
    }

    @Override
    public void destroyNode(String id) {
        NodeMetadata node = null;
        try {
            node = this.computeService.getNodeMetadata(id);
        }
        catch (Exception ex) {
            LOGGER.error("Error while retrieving node metadata.", ex);
        }
        this.computeService.destroyNode(id);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                nodeListener.nodeDestroyed(node);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", ex);
        }
    }

    @Override
    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        Set<? extends NodeMetadata> metadata = this.computeService.destroyNodesMatching(filter);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata nodeMetadata : metadata) {
                    nodeListener.nodeCreated(nodeMetadata);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", ex);
        }
        return metadata;
    }

    @Override
    public void rebootNode(String id) {
        this.computeService.rebootNode(id);
    }

    @Override
    public void rebootNodesMatching(Predicate<NodeMetadata> filter) {
        this.computeService.rebootNodesMatching(filter);
    }

    @Override
    public NodeMetadata getNodeMetadata(String id) {
        return this.computeService.getNodeMetadata(id);
    }

    @Override
    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<ComputeMetadata> filter) {
        return this.computeService.listNodesDetailsMatching(filter);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript, options);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript, options);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        return this.computeService.runScriptOnNode(id, runScript, options);
    }

    @Override
    @Beta
    public ListenableFuture<ExecResponse> submitScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        return this.computeService.submitScriptOnNode(id, runScript, options);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript) {
        return this.computeService.runScriptOnNode(id, runScript);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript, RunScriptOptions options) {
        return this.computeService.runScriptOnNode(id, runScript, options);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript) {
        return this.computeService.runScriptOnNode(id, runScript);
    }

    @Override
    public Image getImage(String id) {
        return this.computeService.getImage(id);
    }

    @Override
    public Optional<ImageExtension> getImageExtension() {
        return this.computeService.getImageExtension();
    }
}

