/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Chars;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Multimaps2;

public class HttpRequest
extends HttpMessage {
    private final String method;
    private final URI endpoint;
    private final List<Character> skips;
    private final List<HttpRequestFilter> filters;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHttpRequest(this);
    }

    protected HttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload, Iterable<Character> skips, Iterable<HttpRequestFilter> filters) {
        super(headers, payload);
        this.method = Preconditions.checkNotNull(method, "method");
        this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
        Preconditions.checkArgument(endpoint.getHost() != null, String.format("endpoint.getHost() is null for %s", endpoint));
        this.skips = ImmutableList.copyOf(Preconditions.checkNotNull(skips, "skips"));
        this.filters = ImmutableList.copyOf(Preconditions.checkNotNull(filters, "filters"));
    }

    public String getRequestLine() {
        return String.format("%s %s HTTP/1.1", this.getMethod(), this.getEndpoint().toASCIIString());
    }

    public String getMethod() {
        return this.method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public char[] getSkips() {
        return Chars.toArray(this.skips);
    }

    public List<HttpRequestFilter> getFilters() {
        return this.filters;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.method, this.endpoint, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest that = (HttpRequest)HttpRequest.class.cast(obj);
        return super.equals(that) && Objects.equal(this.method, that.method) && Objects.equal(this.endpoint, that.endpoint);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").omitNullValues().add("method", this.method).add("endpoint", this.endpoint).add("headers", this.headers).add("payload", this.payload);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends HttpMessage.Builder<T> {
        protected String method;
        protected URI endpoint;
        protected ImmutableList.Builder<Character> skips = ImmutableList.builder();
        protected ImmutableList.Builder<HttpRequestFilter> filters = ImmutableList.builder();

        public T method(String method) {
            this.method = Preconditions.checkNotNull(method, "method");
            return (T)((Builder)this.self());
        }

        public T endpoint(URI endpoint) {
            this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
            return (T)((Builder)this.self());
        }

        public T endpoint(String endpoint) {
            return this.endpoint(URI.create(Preconditions.checkNotNull(endpoint, "endpoint")));
        }

        public T addQueryParam(String name, Iterable<String> values) {
            return this.addQueryParam(name, Iterables.toArray(Preconditions.checkNotNull(values, "values of %s", name), String.class));
        }

        public T addQueryParam(String name, String ... values) {
            return this.addQueryParams(ImmutableMultimap.builder().putAll(Preconditions.checkNotNull(name, "name"), (Object[])Preconditions.checkNotNull(values, "values of %s", name)).build());
        }

        public T addQueryParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            Multimap<String, String> map = Queries.parseQueryToMap(this.endpoint.getQuery());
            map = ImmutableMultimap.builder().putAll(map).putAll(parameters).build();
            return this.replaceQuery(map);
        }

        public T replaceQueryParam(String name, Iterable<String> values) {
            return this.replaceQueryParam(name, Iterables.toArray(Preconditions.checkNotNull(values, "values of %s", name), String.class));
        }

        public T replaceQueryParam(String name, String ... values) {
            return this.replaceQueryParams(ImmutableMultimap.builder().putAll(Preconditions.checkNotNull(name, "name"), (Object[])Preconditions.checkNotNull(values, "values of %s", name)).build());
        }

        public T replaceQueryParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            Multimap<String, String> map = Multimaps2.replaceEntries(Queries.parseQueryToMap(this.endpoint.getRawQuery()), parameters);
            return this.replaceQuery(map);
        }

        private T replaceQuery(Multimap<String, String> map) {
            URI oldURI = this.endpoint;
            String query = Queries.makeQueryLine(map, null, Chars.toArray(this.skips.build()));
            this.endpoint = new UriBuilderImpl().uri(oldURI).replaceQuery(query).buildFromEncodedMap(Collections.EMPTY_MAP);
            return (T)((Builder)this.self());
        }

        public T replacePath(String path) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            Preconditions.checkNotNull(path, "path");
            URI oldURI = this.endpoint;
            this.endpoint = new UriBuilderImpl().uri(oldURI).replacePath(path).buildFromEncodedMap(Collections.EMPTY_MAP);
            return (T)((Builder)this.self());
        }

        public T addFormParam(String name, String ... values) {
            return this.addFormParams(ImmutableMultimap.builder().putAll(Preconditions.checkNotNull(name, "name"), (Object[])Preconditions.checkNotNull(values, "values of %s", name)).build());
        }

        public T addFormParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            ImmutableMultimap<String, String> map = this.payload != null ? Queries.parseQueryToMap(this.payload.getRawContent().toString()) : ImmutableMultimap.of();
            map = ImmutableMultimap.builder().putAll(map).putAll(parameters).build();
            this.payload = Payloads.newUrlEncodedFormPayload(map, new char[0]);
            return (T)((Builder)this.self());
        }

        public T replaceFormParam(String name, String ... values) {
            return this.replaceFormParams(ImmutableMultimap.builder().putAll(Preconditions.checkNotNull(name, "name"), (Object[])Preconditions.checkNotNull(values, "values of %s", name)).build());
        }

        public T replaceFormParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            Multimap<String, String> map = Multimaps2.replaceEntries(this.payload != null ? Queries.parseQueryToMap(this.payload.getRawContent().toString()) : ImmutableMultimap.of(), parameters);
            this.payload = Payloads.newUrlEncodedFormPayload(map, new char[0]);
            return (T)((Builder)this.self());
        }

        public T skips(char[] skips) {
            this.skips = ImmutableList.builder();
            this.skips.addAll(Chars.asList(Preconditions.checkNotNull(skips, "skips")));
            return (T)((Builder)this.self());
        }

        public T filters(Iterable<HttpRequestFilter> filters) {
            this.filters = ImmutableList.builder();
            this.filters.addAll((Iterable)Preconditions.checkNotNull(filters, "filters"));
            return (T)((Builder)this.self());
        }

        public T filter(HttpRequestFilter filter) {
            this.filters.add((Object)Preconditions.checkNotNull(filter, "filter"));
            return (T)((Builder)this.self());
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this.method, this.endpoint, this.headers.build(), this.payload, this.skips.build(), this.filters.build());
        }

        public T fromHttpRequest(HttpRequest in) {
            return ((Builder)((Builder)((Builder)((Builder)super.fromHttpMessage(in)).method(in.getMethod())).endpoint(in.getEndpoint())).skips(in.getSkips())).filters(in.getFilters());
        }
    }
}

