/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class PublicUriForObjectInfo
implements Function<ObjectInfo, URI> {
    private final LoadingCache<String, URI> cdnContainer;
    private final Provider<UriBuilder> uriBuilders;
    private static final URI NEGATIVE_ENTRY = URI.create("http://127.0.0.1");

    @Inject
    public PublicUriForObjectInfo(LoadingCache<String, URI> cdnContainer, Provider<UriBuilder> uriBuilders) {
        this.cdnContainer = cdnContainer;
        this.uriBuilders = uriBuilders;
    }

    @Override
    public URI apply(ObjectInfo from) {
        if (from == null) {
            return null;
        }
        try {
            URI uri = this.cdnContainer.getUnchecked(from.getContainer());
            if (uri == NEGATIVE_ENTRY) {
                return null;
            }
            return this.uriBuilders.get().uri(uri).path(from.getName()).replaceQuery("").build(new Object[0]);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            this.cdnContainer.put(from.getContainer(), NEGATIVE_ENTRY);
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

