/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.filters;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;

public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private final String apiKey;
    private final String secret;
    private final Long timeStamp;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(@Identity String apiKey, @Credential String secret, @TimeStamp Long timeStamp, HttpUtils utils) {
        this.apiKey = apiKey;
        this.secret = secret;
        this.timeStamp = timeStamp;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) {
        String toSign = this.createStringToSign();
        String signatureMd5 = this.getMd5For(toSign);
        String query = request.getEndpoint().getQuery();
        Multimap<String, String> decodedParams = Queries.parseQueryToMap(query);
        decodedParams.replaceValues("sig", ImmutableSet.of(signatureMd5));
        decodedParams.replaceValues("api_key", ImmutableSet.of(this.apiKey));
        String updatedQuery = Queries.makeQueryLine(decodedParams, null, new char[0]);
        String requestBasePart = request.getEndpoint().toASCIIString();
        String updatedEndpoint = requestBasePart.substring(0, requestBasePart.indexOf("?") + 1) + updatedQuery;
        request = ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(updatedEndpoint)).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    private String createStringToSign() {
        return String.format("%s%s%s", this.apiKey, this.secret, this.timeStamp);
    }

    private String getMd5For(String stringToHash) {
        try {
            return CryptoStreams.md5Hex(InputSuppliers.of(stringToHash));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

