/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.MediaType;

public class BlockDevice
extends Device {
    private final int index;

    public BlockDevice(String driveUuid, MediaType mediaType, int index) {
        super(driveUuid, mediaType);
        Preconditions.checkArgument(index >= 0 && index < 8, "index must be between 0 and 7");
        this.index = index;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockDevice other = (BlockDevice)obj;
        return this.index == other.index;
    }

    @Override
    public String getId() {
        return String.format("block:%d", this.index);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String toString() {
        return "[id=" + this.getId() + ", driveUuid=" + this.driveUuid + ", mediaType=" + (Object)((Object)this.mediaType) + "]";
    }

    public static class Builder
    extends Device.Builder {
        private final int index;

        public Builder(int index) {
            this.index = index;
        }

        @Override
        public Device build() {
            return new BlockDevice(this.uuid, this.mediaType, this.index);
        }
    }
}

