/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;

public class PublicIpInstanceIdPair
implements Comparable<PublicIpInstanceIdPair> {
    private final String region;
    @Nullable
    private final String instanceId;
    private final String publicIp;

    public PublicIpInstanceIdPair(String region, String publicIp, @Nullable String instanceId) {
        this.region = Preconditions.checkNotNull(region, "region");
        this.instanceId = instanceId;
        this.publicIp = Preconditions.checkNotNull(publicIp, "publicIp");
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(PublicIpInstanceIdPair o) {
        return this == o ? 0 : this.getPublicIp().compareTo(o.getPublicIp());
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.publicIp == null ? 0 : this.publicIp.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicIpInstanceIdPair other = (PublicIpInstanceIdPair)obj;
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.publicIp == null ? other.publicIp != null : !this.publicIp.equals(other.publicIp)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }
}

