/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import org.jclouds.util.Strings2;

public class Credentials {
    public static final Credentials NO_CREDENTIALS = new Credentials(null, null);
    public final String identity;
    public final String credential;

    public Credentials(String identity, String credential) {
        this.identity = identity;
        this.credential = credential;
    }

    public static Credentials parse(URI uri) {
        String credential;
        Preconditions.checkNotNull(uri, "uri");
        ArrayList<String> userInfo = Lists.newArrayList(Splitter.on(':').split(Preconditions.checkNotNull(uri.getUserInfo(), "no userInfo in " + uri)));
        String identity = (String)Preconditions.checkNotNull(userInfo.get(0), "no username in " + uri.getUserInfo());
        if (Strings2.isUrlEncoded(identity)) {
            identity = Strings2.urlDecode(identity);
        }
        String string = credential = userInfo.size() > 1 ? (String)userInfo.get(1) : null;
        if (credential != null && Strings2.isUrlEncoded(credential)) {
            credential = Strings2.urlDecode(credential);
        }
        return new Credentials(identity, credential);
    }

    public Builder<? extends Credentials> toBuilder() {
        return new Builder().identity(this.identity).credential(this.credential);
    }

    public String toString() {
        return "[identity=" + this.identity + ", credential=" + this.credential + "]";
    }

    public int hashCode() {
        return Objects.hashCode(this.identity, this.credential);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)obj;
        if (!Objects.equal(this.identity, other.identity)) {
            return false;
        }
        return Objects.equal(this.credential, other.credential);
    }

    public static class Builder<T extends Credentials> {
        protected String identity;
        protected String credential;

        public Builder<T> identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder<T> credential(String credential) {
            this.credential = credential;
            return this;
        }

        public T build() {
            return (T)new Credentials(this.identity, this.credential);
        }
    }
}

