/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Date;
import javax.inject.Singleton;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.date.DateService;

@Singleton
public class DateServiceDateCodecFactory
implements DateCodecFactory {
    private final DateCodec rfc1123Codec;
    private final DateServiceIso8601Codec iso8601Codec;

    @Inject
    public DateServiceDateCodecFactory(DateServiceRfc1123Codec rfc1123Codec, DateServiceIso8601Codec iso8601Codec) {
        this.rfc1123Codec = Preconditions.checkNotNull(rfc1123Codec, "rfc1123Codec");
        this.iso8601Codec = Preconditions.checkNotNull(iso8601Codec, "iso8601Codec");
    }

    @Override
    public DateCodec rfc1123() {
        return this.rfc1123Codec;
    }

    @Override
    public DateCodec iso8601() {
        return this.iso8601Codec;
    }

    @Singleton
    public static class DateServiceIso8601Codec
    implements DateCodec {
        protected final DateService dateService;

        @Inject
        public DateServiceIso8601Codec(DateService dateService) {
            this.dateService = Preconditions.checkNotNull(dateService, "dateService");
        }

        @Override
        public Date toDate(String date) throws IllegalArgumentException {
            return this.dateService.iso8601DateParse(date);
        }

        @Override
        public String toString(Date date) {
            return this.dateService.iso8601DateFormat(date);
        }

        public String toString() {
            return "iso8601()";
        }
    }

    @Singleton
    public static class DateServiceRfc1123Codec
    implements DateCodec {
        protected final DateService dateService;

        @Inject
        public DateServiceRfc1123Codec(DateService dateService) {
            this.dateService = Preconditions.checkNotNull(dateService, "dateService");
        }

        @Override
        public Date toDate(String date) throws IllegalArgumentException {
            return this.dateService.rfc1123DateParse(date);
        }

        @Override
        public String toString(Date date) {
            return this.dateService.rfc1123DateFormat(date);
        }

        public String toString() {
            return "rfc1123()";
        }
    }
}

