/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.xml.DimensionHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetricHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Metric> {
    private final DimensionHandler dimensionHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<Dimension> dimensions = Sets.newLinkedHashSet();
    private boolean inDimensions;
    private String metricName;
    private String namespace;

    @Inject
    public MetricHandler(DimensionHandler dimensionHandler) {
        this.dimensionHandler = dimensionHandler;
    }

    public boolean inDimensions() {
        return this.inDimensions;
    }

    @Override
    public Metric getResult() {
        Metric metric = new Metric(this.metricName, this.namespace, this.dimensions);
        this.dimensions = Sets.newLinkedHashSet();
        this.metricName = null;
        this.namespace = null;
        return metric;
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (!this.inDimensions && SaxUtils.equalsOrSuffix(qName, "member")) {
            this.inDimensions = true;
        }
        if (this.inDimensions) {
            this.dimensionHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.inDimensions) {
            if (qName.equals("Dimensions")) {
                this.inDimensions = false;
            } else if (qName.equals("member")) {
                this.dimensions.add(this.dimensionHandler.getResult());
            } else {
                this.dimensionHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("MetricName")) {
            this.metricName = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("Namespace")) {
            this.namespace = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inDimensions) {
            this.dimensionHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

