/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.cloudwatch.domain.Unit;

public class MetricDatum {
    private final Set<Dimension> dimensions;
    private final String metricName;
    private final Optional<StatisticValues> statisticValues;
    private final Optional<Date> timestamp;
    private final Unit unit;
    private final Optional<Double> value;

    protected MetricDatum(Iterable<Dimension> dimensions, String metricName, Optional<StatisticValues> statisticValues, Optional<Date> timestamp, Unit unit, Optional<Double> value) {
        this.dimensions = ImmutableSet.copyOf(Preconditions.checkNotNull(dimensions, "dimensions"));
        this.metricName = Preconditions.checkNotNull(metricName, "metricName");
        this.statisticValues = Preconditions.checkNotNull(statisticValues, "statisticValues");
        this.timestamp = Preconditions.checkNotNull(timestamp, "timestamp");
        this.unit = Preconditions.checkNotNull(unit, "unit");
        this.value = Preconditions.checkNotNull(value, "value");
    }

    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Optional<StatisticValues> getStatisticValues() {
        return this.statisticValues;
    }

    public Optional<Date> getTimestamp() {
        return this.timestamp;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Optional<Double> getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDatum that = (MetricDatum)MetricDatum.class.cast(o);
        return Objects.equal(this.dimensions, that.dimensions) && Objects.equal(this.metricName, that.metricName) && Objects.equal(this.statisticValues, that.statisticValues) && Objects.equal(this.timestamp, that.timestamp) && Objects.equal((Object)this.unit, (Object)that.unit) && Objects.equal(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.dimensions, this.metricName, this.statisticValues, this.timestamp, this.unit, this.value});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").omitNullValues().add("dimensions", this.dimensions).add("metricName", this.metricName).add("statisticValues", this.statisticValues.orNull()).add("timestamp", this.timestamp.orNull()).add("unit", (Object)this.unit).add("value", this.value.orNull());
    }

    public static class Builder {
        private ImmutableList.Builder<Dimension> dimensions = ImmutableList.builder();
        private String metricName;
        private Optional<StatisticValues> statisticValues = Optional.absent();
        private Optional<Date> timestamp = Optional.absent();
        private Unit unit = Unit.NONE;
        private Optional<Double> value = Optional.absent();

        public Builder dimensions(Iterable<Dimension> dimensions) {
            this.dimensions.addAll((Iterable)Preconditions.checkNotNull(dimensions, "dimensions"));
            return this;
        }

        public Builder dimension(Dimension dimension) {
            this.dimensions.add((Object)Preconditions.checkNotNull(dimension, "dimension"));
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public Builder statisticValues(StatisticValues statisticValues) {
            this.statisticValues = Optional.fromNullable(statisticValues);
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = Optional.fromNullable(timestamp);
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            return this;
        }

        public Builder value(Double value) {
            this.value = Optional.fromNullable(value);
            return this;
        }

        public MetricDatum build() {
            return new MetricDatum(this.dimensions.build(), this.metricName, this.statisticValues, this.timestamp, this.unit, this.value);
        }
    }
}

