/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.binders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Inject;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.GetMetricStatistics;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Beta
public class GetMetricStatisticsBinder
implements Binder {
    private final DateService dateService;

    @Inject
    protected GetMetricStatisticsBinder(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        GetMetricStatistics getRequest = (GetMetricStatistics)GetMetricStatistics.class.cast(Preconditions.checkNotNull(payload, "GetMetricStatistics must be set!"));
        int dimensionIndex = 1;
        int statisticIndex = 1;
        ImmutableMultimap.Builder<String, String> formParameters = ImmutableMultimap.builder();
        for (Dimension dimension : getRequest.getDimensions()) {
            formParameters.put("Dimensions.member." + dimensionIndex + ".Name", dimension.getName());
            formParameters.put("Dimensions.member." + dimensionIndex + ".Value", dimension.getValue());
            ++dimensionIndex;
        }
        if (getRequest.getEndTime().isPresent()) {
            formParameters.put("EndTime", this.dateService.iso8601SecondsDateFormat(getRequest.getEndTime().get()));
        }
        formParameters.put("MetricName", getRequest.getMetricName());
        formParameters.put("Namespace", getRequest.getNamespace());
        formParameters.put("Period", Integer.toString(getRequest.getPeriod()));
        if (getRequest.getStartTime().isPresent()) {
            formParameters.put("StartTime", this.dateService.iso8601SecondsDateFormat(getRequest.getStartTime().get()));
        }
        for (Statistics statistic : getRequest.getStatistics()) {
            formParameters.put("Statistics.member." + statisticIndex, statistic.toString());
            ++statisticIndex;
        }
        if (getRequest.getUnit().isPresent()) {
            formParameters.put("Unit", getRequest.getUnit().get().toString());
        }
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(formParameters.build())).build();
    }
}

