/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListISOsOptions
extends AccountInDomainOptions {
    public static final ListISOsOptions NONE = new ListISOsOptions();
    private static final Set<String> TRUE = ImmutableSet.of(Boolean.toString(true));
    private static final Set<String> FALSE = ImmutableSet.of(Boolean.toString(false));

    public ListISOsOptions bootable() {
        this.queryParameters.replaceValues("bootable", TRUE);
        return this;
    }

    public ListISOsOptions notBootable() {
        this.queryParameters.replaceValues("bootable", FALSE);
        return this;
    }

    public ListISOsOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues("hypervisor", ImmutableSet.of(hypervisor));
        return this;
    }

    public ListISOsOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id));
        return this;
    }

    public ListISOsOptions isoFilter(ISO.ISOFilter isoFilter) {
        this.queryParameters.replaceValues("isofilter", ImmutableSet.of(isoFilter.name()));
        return this;
    }

    public ListISOsOptions isPublic() {
        this.queryParameters.replaceValues("ispublic", TRUE);
        return this;
    }

    public ListISOsOptions isPrivate() {
        this.queryParameters.replaceValues("ispublic", FALSE);
        return this;
    }

    public ListISOsOptions isReady() {
        this.queryParameters.replaceValues("isready", TRUE);
        return this;
    }

    public ListISOsOptions isNotReady() {
        this.queryParameters.replaceValues("isready", FALSE);
        return this;
    }

    public ListISOsOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListISOsOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListISOsOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId));
        return this;
    }

    public static class Builder {
        public static ListISOsOptions accountInDomain(String account, String domainId) {
            return (ListISOsOptions)new ListISOsOptions().accountInDomain(account, domainId);
        }

        public static ListISOsOptions bootable() {
            return new ListISOsOptions().bootable();
        }

        public static ListISOsOptions notBootable() {
            return new ListISOsOptions().notBootable();
        }

        public static ListISOsOptions domainId(String domainId) {
            return (ListISOsOptions)new ListISOsOptions().domainId(domainId);
        }

        public static ListISOsOptions hypervisor(String hypervisor) {
            return new ListISOsOptions().hypervisor(hypervisor);
        }

        public static ListISOsOptions id(String id) {
            return new ListISOsOptions().id(id);
        }

        public static ListISOsOptions isoFilter(ISO.ISOFilter isoFilter) {
            return new ListISOsOptions().isoFilter(isoFilter);
        }

        public static ListISOsOptions isPublic() {
            return new ListISOsOptions().isPublic();
        }

        public static ListISOsOptions isPrivate() {
            return new ListISOsOptions().isPrivate();
        }

        public static ListISOsOptions isReady() {
            return new ListISOsOptions().isReady();
        }

        public static ListISOsOptions isNotReady() {
            return new ListISOsOptions().isNotReady();
        }

        public static ListISOsOptions keyword(String keyword) {
            return new ListISOsOptions().keyword(keyword);
        }

        public static ListISOsOptions name(String name) {
            return new ListISOsOptions().name(name);
        }

        public static ListISOsOptions zoneId(String zoneId) {
            return new ListISOsOptions().zoneId(zoneId);
        }
    }
}

