/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.util.Throwables2;

@Singleton
public class ReturnVoidOnNotFoundOr404OrUnableToFindAccountOwner
implements Function<Exception, Void> {
    private final ReturnVoidOnNotFoundOr404 rto404;

    @Inject
    private ReturnVoidOnNotFoundOr404OrUnableToFindAccountOwner(ReturnVoidOnNotFoundOr404 rto404) {
        this.rto404 = Preconditions.checkNotNull(rto404, "rto404");
    }

    @Override
    public Void apply(Exception from) {
        IllegalStateException e = Throwables2.getFirstThrowableOfType(from, IllegalStateException.class);
        if (e != null && e.getMessage().indexOf("Unable to find account owner for") != -1) {
            return null;
        }
        return this.rto404.apply(from);
    }
}

