/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.functions.ParseTypedAsyncJob;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;

@Singleton
public class ParseAsyncJobFromHttpResponse
implements Function<HttpResponse, AsyncJob<?>> {
    private final UnwrapOnlyJsonValue<AsyncJob<Map<String, JsonBall>>> parser;
    private final ParseTypedAsyncJob parseTyped;

    @Inject
    public ParseAsyncJobFromHttpResponse(ParseTypedAsyncJob parseTyped, UnwrapOnlyJsonValue<AsyncJob<Map<String, JsonBall>>> parser) {
        this.parseTyped = Preconditions.checkNotNull(parseTyped, "parseTyped");
        this.parser = Preconditions.checkNotNull(parser, "parser");
    }

    @Override
    public AsyncJob<?> apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        AsyncJob<Map<String, JsonBall>> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", response);
        return this.parseTyped.apply(toParse);
    }
}

