/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.domain.ISOPermissions;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.DeleteISOOptions;
import org.jclouds.cloudstack.options.ExtractISOOptions;
import org.jclouds.cloudstack.options.ListISOsOptions;
import org.jclouds.cloudstack.options.RegisterISOOptions;
import org.jclouds.cloudstack.options.UpdateISOOptions;
import org.jclouds.cloudstack.options.UpdateISOPermissionsOptions;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
@SkipEncoding(value={47, 44})
public interface ISOAsyncClient {
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"attachIso"})
    @Unwrap
    public ListenableFuture<AsyncCreateResponse> attachISO(@QueryParam(value="id") String var1, @QueryParam(value="virtualmachineid") String var2);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"detachIso"})
    @Unwrap
    public ListenableFuture<AsyncCreateResponse> detachISO(@QueryParam(value="virtualmachineid") String var1);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command", "listAll"}, values={"listIsos", "true"})
    @SelectJson(value="iso")
    @OnlyElement
    public ListenableFuture<ISO> getISO(@QueryParam(value="id") String var1);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command", "listAll"}, values={"listIsos", "true"})
    @SelectJson(value="iso")
    public ListenableFuture<Set<ISO>> listISOs(ListISOsOptions ... var1);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"registerIso"})
    @Unwrap
    public ListenableFuture<ISO> registerISO(@QueryParam(value="name") String var1, @QueryParam(value="displaytext") String var2, @QueryParam(value="url") String var3, @QueryParam(value="zoneid") String var4, RegisterISOOptions ... var5);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"updateIso"})
    @Unwrap
    public ListenableFuture<ISO> updateISO(@QueryParam(value="id") String var1, UpdateISOOptions ... var2);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"deleteIso"})
    @Unwrap
    public ListenableFuture<AsyncCreateResponse> deleteISO(@QueryParam(value="id") String var1, DeleteISOOptions ... var2);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"copyIso"})
    @Unwrap
    public ListenableFuture<AsyncCreateResponse> copyISO(@QueryParam(value="id") String var1, @QueryParam(value="sourcezoneid") String var2, @QueryParam(value="destzoneid") String var3);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"updateIsoPermissions"})
    @Unwrap
    public ListenableFuture<Void> updateISOPermissions(@QueryParam(value="id") String var1, UpdateISOPermissionsOptions ... var2);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command", "listAll"}, values={"listIsoPermissions", "true"})
    @SelectJson(value="templatepermission")
    public ListenableFuture<ISOPermissions> listISOPermissions(@QueryParam(value="id") String var1, AccountInDomainOptions ... var2);

    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"extractIso"})
    @Unwrap
    public ListenableFuture<AsyncCreateResponse> extractISO(@QueryParam(value="id") String var1, @QueryParam(value="mode") ExtractMode var2, @QueryParam(value="zoneid") String var3, ExtractISOOptions ... var4);
}

