/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.ConfigurationEntry;
import org.jclouds.cloudstack.features.ConfigurationAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.ListConfigurationEntriesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalConfigurationAsyncClient
extends ConfigurationAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listConfigurations", "true"})
    @SelectJson(value="configuration")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<ConfigurationEntry>> listConfigurationEntries(ListConfigurationEntriesOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"updateConfiguration"})
    @SelectJson(value="configuration")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<ConfigurationEntry> updateConfigurationEntry(@QueryParam(value="name") String var1, @QueryParam(value="value") String var2);
}

