/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.Queries;
import org.jclouds.rest.Binder;

@Singleton
public class BindAccountSecurityGroupPairsToIndexedQueryParams
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public BindAccountSecurityGroupPairsToIndexedQueryParams(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = Preconditions.checkNotNull(uriBuilderProvider, "uriBuilderProvider");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof Multimap, "this binder is only valid for Multimaps!");
        Multimap pairs = (Multimap)Preconditions.checkNotNull(input, "account group pairs");
        Preconditions.checkArgument(pairs.size() > 0, "you must specify at least one account, group pair");
        UriBuilder builder = this.uriBuilderProvider.get();
        builder.uri(request.getEndpoint());
        ImmutableMultimap.Builder<String, String> map = ImmutableMultimap.builder().putAll(Queries.parseQueryToMap(request.getEndpoint().getQuery()));
        int i = 0;
        for (Map.Entry entry : pairs.entries()) {
            map.put(String.format("usersecuritygrouplist[%d].account", i), (String)entry.getKey()).put(String.format("usersecuritygrouplist[%d].group", i++), (String)entry.getValue());
        }
        builder.replaceQuery(Queries.makeQueryLine(map.build(), null, new char[0]));
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(builder.build(new Object[0]))).build();
    }
}

