/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;

@Singleton
public class CloudServersComputeServiceAdapter
implements ComputeServiceAdapter<Server, Flavor, Image, Location> {
    protected final CloudServersClient client;

    @Inject
    protected CloudServersComputeServiceAdapter(CloudServersClient client) {
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Server server = this.client.createServer(name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()), CreateServerOptions.Builder.withMetadata(ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue(template.getOptions())));
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Server>(server, server.getId() + "", LoginCredentials.builder().password(server.getAdminPass()).build());
    }

    @Override
    public Iterable<Flavor> listHardwareProfiles() {
        return this.client.listFlavors(ListOptions.Builder.withDetails());
    }

    @Override
    public Iterable<Image> listImages() {
        return this.client.listImages(ListOptions.Builder.withDetails());
    }

    @Override
    public Iterable<Server> listNodes() {
        return this.client.listServers(ListOptions.Builder.withDetails());
    }

    @Override
    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    @Override
    public Server getNode(String id) {
        int serverId = Integer.parseInt(id);
        return this.client.getServer(serverId);
    }

    @Override
    public Image getImage(String id) {
        int imageId = Integer.parseInt(id);
        return this.client.getImage(imageId);
    }

    @Override
    public void destroyNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.deleteServer(serverId);
    }

    @Override
    public void rebootNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.rebootServer(serverId, RebootType.HARD);
    }

    @Override
    public void resumeNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    @Override
    public void suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }
}

