/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.loadbalancer.strategy;

import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersClient;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.DestroyLoadBalancerStrategy;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class CloudLoadBalancersDestroyLoadBalancerStrategy
implements DestroyLoadBalancerStrategy {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    private final CloudLoadBalancersClient client;
    private final GetLoadBalancerMetadataStrategy getLoadBalancer;

    @Inject
    protected CloudLoadBalancersDestroyLoadBalancerStrategy(CloudLoadBalancersClient client, GetLoadBalancerMetadataStrategy getLoadBalancer) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.getLoadBalancer = Preconditions.checkNotNull(getLoadBalancer, "getLoadBalancer");
    }

    @Override
    public LoadBalancerMetadata destroyLoadBalancer(String id) {
        String[] parts = Preconditions.checkNotNull(id, "id").split("/");
        String region = parts[0];
        int lbId = Integer.parseInt(parts[1]);
        this.client.getLoadBalancerClient(region).removeLoadBalancer(lbId);
        return this.getLoadBalancer.getLoadBalancer(id);
    }
}

