/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.jclouds.cloudloadbalancers.domain.NodeRequest;
import org.jclouds.cloudloadbalancers.domain.VirtualIP;
import org.jclouds.cloudloadbalancers.domain.internal.BaseLoadBalancer;

public class LoadBalancerRequest
extends BaseLoadBalancer<NodeRequest, LoadBalancerRequest> {
    private final List<Map<String, String>> virtualIps;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public LoadBalancerRequest(String name, String protocol, int port, String algorithm, Iterable<NodeRequest> nodes, VirtualIP.Type virtualIPType, Integer virtualIPId) {
        this(name, protocol, port, algorithm, nodes, LoadBalancerRequest.getVirtualIPsFromOptions(virtualIPType, virtualIPId));
    }

    private LoadBalancerRequest(String name, String protocol, int port, String algorithm, Iterable<NodeRequest> nodes, List<Map<String, String>> virtualIPsFromOptions) {
        super(name, protocol, port, algorithm, nodes);
        this.virtualIps = Preconditions.checkNotNull(virtualIPsFromOptions, "virtualIPsFromOptions");
    }

    static List<Map<String, String>> getVirtualIPsFromOptions(VirtualIP.Type virtualIPType, Integer virtualIPId) {
        Preconditions.checkArgument(virtualIPType == null || virtualIPId == null, "virtualIPType and virtualIPId cannot both be specified");
        if (virtualIPType != null) {
            return ImmutableList.of(ImmutableMap.of("type", virtualIPType.name()));
        }
        if (virtualIPId != null) {
            return ImmutableList.of(ImmutableMap.of("id", virtualIPId.toString()));
        }
        throw new IllegalArgumentException("virtualIPType or virtualIPId must be specified");
    }

    @Override
    public String toString() {
        return String.format("[algorithm=%s, name=%s, nodes=%s, port=%s, protocol=%s, virtualIps=%s]", this.algorithm, this.name, this.nodes, this.port, this.protocol, this.virtualIps);
    }

    public static class Builder
    extends BaseLoadBalancer.Builder<NodeRequest, LoadBalancerRequest> {
        private VirtualIP.Type virtualIPType;
        private Integer virtualIPId;
        private List<Map<String, String>> virtualIps;

        public Builder virtualIPId(Integer virtualIPId) {
            this.virtualIPId = virtualIPId;
            return this;
        }

        public Builder virtualIPType(VirtualIP.Type virtualIPType) {
            this.virtualIPType = virtualIPType;
            return this;
        }

        public LoadBalancerRequest build() {
            return this.virtualIps == null ? new LoadBalancerRequest(this.name, this.protocol, (int)this.port, this.algorithm, (Iterable<NodeRequest>)this.nodes, this.virtualIPType, this.virtualIPId) : new LoadBalancerRequest(this.name, this.protocol, (int)this.port, this.algorithm, (Iterable)this.nodes, this.virtualIps);
        }

        public Builder nodes(Iterable<NodeRequest> nodes) {
            this.nodes = ImmutableSet.copyOf(Preconditions.checkNotNull(nodes, "nodes"));
            return this;
        }

        public Builder node(NodeRequest nodes) {
            this.nodes.add(Preconditions.checkNotNull(nodes, "nodes"));
            return this;
        }

        private Builder virtualIPs(List<Map<String, String>> virtualIPs) {
            this.virtualIps = virtualIPs;
            return this;
        }

        public Builder algorithm(String algorithm) {
            return (Builder)Builder.class.cast(super.algorithm(algorithm));
        }

        public Builder from(LoadBalancerRequest in) {
            return ((Builder)Builder.class.cast(super.from(in))).virtualIPs(in.virtualIps);
        }

        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        public Builder port(Integer port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder protocol(String protocol) {
            return (Builder)Builder.class.cast(super.protocol(protocol));
        }
    }
}

