/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.strategy.MkdirStrategy;
import org.jclouds.io.Payloads;

@Singleton
public class MarkerFileMkdirStrategy
implements MkdirStrategy {
    @Inject(optional=true)
    @Named(value="jclouds.blobstore.directorysuffix")
    protected String directorySuffix = "";
    private final BlobStore blobStore;

    @Inject
    MarkerFileMkdirStrategy(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    @Override
    public void execute(String containerName, String directory) {
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(directory + this.directorySuffix).type(StorageType.RELATIVE_PATH).payload(Payloads.newByteArrayPayload(new byte[0])).contentType("application/directory").build());
    }
}

