/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.options.ListContainerOptions;

@Singleton
public class ListOptionsToListBlobsOptions
implements Function<ListContainerOptions, ListBlobsOptions> {
    @Override
    public ListBlobsOptions apply(ListContainerOptions from) {
        Preconditions.checkNotNull(from, "set options to instance NONE instead of passing null");
        ListBlobsOptions httpOptions = new ListBlobsOptions();
        if (!from.isRecursive()) {
            httpOptions.delimiter("/");
        }
        if (from.getDir() != null) {
            httpOptions.prefix(from.getDir().endsWith("/") ? from.getDir() : from.getDir() + "/");
        }
        if (from.getMarker() != null) {
            httpOptions.marker(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions.maxResults(from.getMaxResults());
        }
        if (from.isDetailed()) {
            httpOptions.includeMetadata();
        }
        return httpOptions;
    }
}

