/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.util.Strings2;

@Singleton
public class FormSigner
implements HttpRequestFilter,
RequestSigner {
    public static String[] mandatoryParametersForSignature = new String[]{"Action", "SignatureMethod", "SignatureVersion", "Version"};
    private final SignatureWire signatureWire;
    private final String apiVersion;
    private final String accessKey;
    private final String secretKey;
    private final Provider<String> dateService;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;
    public static final Comparator<Map.Entry<String, String>> sortAWSFirst = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            if (o1.getKey().startsWith("AWSAccessKeyId")) {
                return -1;
            }
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    @Inject
    public FormSigner(SignatureWire signatureWire, @ApiVersion String apiVersion, @Identity String accessKey, @Credential String secretKey, @TimeStamp Provider<String> dateService, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.apiVersion = apiVersion;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.dateService = dateService;
        this.crypto = crypto;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull(request.getFirstHeaderOrNull("Host"), "request is not ready to sign; host not present");
        Multimap<String, String> decodedParams = Queries.parseQueryToMap(request.getPayload().getRawContent().toString());
        decodedParams.replaceValues("Version", ImmutableSet.of(this.apiVersion));
        this.addSigningParams(decodedParams);
        this.validateParams(decodedParams);
        String stringToSign = this.createStringToSign(request, decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature(decodedParams, signature);
        request = this.setPayload(request, decodedParams);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    String[] sortForSigning(String queryLine) {
        String[] parts = queryLine.split("&");
        Arrays.sort(parts, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.startsWith("AWSAccessKeyId")) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
        return parts;
    }

    HttpRequest setPayload(HttpRequest request, Multimap<String, String> decodedParams) {
        request.setPayload(Queries.makeQueryLine(decodedParams, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                if (o1.getKey().startsWith("Action") || o2.getKey().startsWith("AWSAccessKeyId")) {
                    return -1;
                }
                if (o1.getKey().startsWith("AWSAccessKeyId") || o2.getKey().startsWith("Action")) {
                    return 1;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        }, new char[0]));
        request.getPayload().getContentMetadata().setContentType("application/x-www-form-urlencoded");
        return request;
    }

    @VisibleForTesting
    void validateParams(Multimap<String, String> params) {
        for (String parameter : mandatoryParametersForSignature) {
            Preconditions.checkState(params.containsKey(parameter), "parameter " + parameter + " is required for signature");
        }
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues("Signature", ImmutableList.of(signature));
    }

    @Override
    @VisibleForTesting
    public String sign(String stringToSign) {
        String signature;
        try {
            signature = CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(stringToSign), this.crypto.hmacSHA256(this.secretKey.getBytes())));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Strings2.toInputStream(signature));
            }
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
        return signature;
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(request.getMethod()).append("\n");
        stringToSign.append(request.getFirstHeaderOrNull("Host").toLowerCase()).append("\n");
        stringToSign.append(request.getEndpoint().getPath()).append("\n");
        stringToSign.append(this.buildCanonicalizedString(decodedParams));
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(stringToSign.toString());
        }
        return stringToSign.toString();
    }

    @VisibleForTesting
    String buildCanonicalizedString(Multimap<String, String> decodedParams) {
        return Queries.makeQueryLine(decodedParams, sortAWSFirst, new char[0]);
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.replaceValues("SignatureMethod", ImmutableList.of("HmacSHA256"));
        params.replaceValues("SignatureVersion", ImmutableList.of("2"));
        params.replaceValues("Timestamp", ImmutableList.of(this.dateService.get()));
        params.replaceValues("AWSAccessKeyId", ImmutableList.of(this.accessKey));
        params.removeAll("Signature");
    }

    @Override
    public String createStringToSign(HttpRequest input) {
        return this.createStringToSign(input, Queries.parseQueryToMap(input.getPayload().getRawContent().toString()));
    }
}

