/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.Tag;
import org.jclouds.aws.ec2.xml.TagHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeTagsResponseHandler
extends ParseSax.HandlerWithResult<Set<Tag>> {
    private Set<Tag> tags = Sets.newLinkedHashSet();
    private final TagHandler tagHandler;

    @Inject
    public DescribeTagsResponseHandler(TagHandler tagHandler) {
        this.tagHandler = tagHandler;
    }

    @Override
    public Set<Tag> getResult() {
        return this.tags;
    }

    @Override
    public ParseSax.HandlerWithResult<Set<Tag>> setContext(HttpRequest request) {
        this.tagHandler.setContext(request);
        return super.setContext(request);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!qName.equals("item")) {
            this.tagHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("item")) {
            this.tags.add(this.tagHandler.getResult());
        }
        this.tagHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.tagHandler.characters(ch, start, length);
    }
}

