/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.functions.ObjectMD5;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.ListBlobsInContainer;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.concurrent.Futures;
import org.jclouds.logging.Logger;

@Singleton
public class FindMD5InUserMetadata
implements ContainsValueInListStrategy {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ObjectMD5 objectMD5;
    protected final ListBlobsInContainer getAllBlobMetadata;
    private final AtmosAsyncClient client;
    private final ExecutorService userExecutor;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    FindMD5InUserMetadata(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ObjectMD5 objectMD5, ListBlobsInContainer getAllBlobMetadata, AtmosAsyncClient client) {
        this.objectMD5 = objectMD5;
        this.getAllBlobMetadata = getAllBlobMetadata;
        this.client = client;
        this.userExecutor = userExecutor;
    }

    @Override
    public boolean execute(String containerName, Object value, ListContainerOptions options) {
        Map exceptions;
        final byte[] toSearch = this.objectMD5.apply(value);
        final SynchronousQueue queue = new SynchronousQueue();
        HashMap<String, ListenableFuture<AtmosObject>> responses = Maps.newHashMap();
        for (BlobMetadata blobMetadata : this.getAllBlobMetadata.execute(containerName, options)) {
            final ListenableFuture<AtmosObject> future = Futures.makeListenable(this.client.headFile(containerName + "/" + blobMetadata.getName()), this.userExecutor);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        AtmosObject object = (AtmosObject)future.get();
                        Preconditions.checkNotNull(object.getSystemMetadata(), object + " has no content metadata");
                        if (object.getSystemMetadata().getContentMD5() != null) {
                            if (Arrays.equals(toSearch, object.getSystemMetadata().getContentMD5())) {
                                queue.put(true);
                            }
                        } else {
                            FindMD5InUserMetadata.this.logger.debug("object %s has no content md5", object.getSystemMetadata().getObjectID());
                        }
                    }
                    catch (InterruptedException e) {
                        Throwables.propagate(e);
                    }
                    catch (ExecutionException e) {
                        Throwables.propagate(e);
                    }
                }
            }, this.userExecutor);
            responses.put(blobMetadata.getName(), future);
        }
        try {
            exceptions = FutureIterables.awaitCompletion(responses, this.userExecutor, this.maxTime, this.logger, String.format("searching for md5 in container %s", containerName));
        }
        catch (TimeoutException timeoutException) {
            throw Throwables.propagate(timeoutException);
        }
        if (exceptions.size() > 0) {
            throw new BlobRuntimeException(String.format("searching for md5 in container %s: %s", containerName, exceptions));
        }
        try {
            return queue.poll(1L, TimeUnit.MICROSECONDS) != null;
        }
        catch (InterruptedException interruptedException) {
            Throwables.propagate(interruptedException);
            return false;
        }
        catch (Exception exception) {
            Throwables.propagateIfPossible(exception, BlobRuntimeException.class);
            throw new BlobRuntimeException(String.format("Error searching for ETAG of value: [%s] in container:%s", value, containerName), exception);
        }
    }
}

