/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.binders.BindUserMetadataToHeaders;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindMetadataToHeaders
implements Binder {
    private final BindUserMetadataToHeaders metaBinder;

    @Inject
    protected BindMetadataToHeaders(BindUserMetadataToHeaders metaBinder) {
        this.metaBinder = metaBinder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof AtmosObject, "this binder is only valid for AtmosObject!");
        Preconditions.checkNotNull(request, "request");
        AtmosObject object = (AtmosObject)AtmosObject.class.cast(input);
        Preconditions.checkNotNull(object.getPayload(), "object payload");
        Preconditions.checkArgument(object.getPayload().getContentMetadata().getContentLength() != null, "contentLength must be set, streaming not supported");
        return this.metaBinder.bindToRequest(request, object.getUserMetadata());
    }
}

