/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import com.google.common.base.Strings;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManager;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManagerFactory;
import org.fusesource.fabric.service.jclouds.firewall.Rule;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;

@Command(name="cloud-firewall-edit", scope="fabric", description="Manages the firewall of a cloud container.")
public class CloudFirewallEdit
extends FabricCommand {
    @Option(name="--port", required=false, multiValued=true, description="The target port.")
    private int[] port;
    @Option(name="--flush", required=false, description="Flush all rules.")
    private boolean flush;
    @Option(name="--revoke", required=false, description="Revokes the rule. This will block access to the specified port.")
    private boolean revoke;
    @Option(name="--source-cidr", required=false, description="The source cidr to grant or revoke access.")
    private String sourceCidr;
    @Option(name="--source-container", required=false, description="The source container to grant or revoke access.")
    private String sourceContainerName;
    @Option(name="--target-node-id", required=false, description="The target node id.")
    private String targetNodeId;
    @Option(name="--target-container", required=false, description="The target container name.")
    private String targetContainerName;
    @Option(name="--name", required=false, description="The service context name. Used to distinct between multiple service of the same provider/api.")
    private String contextName;
    private FirewallManagerFactory firewallManagerFactory;
    private List<ComputeService> computeServices;

    private boolean validateArguments() {
        if (Strings.isNullOrEmpty(this.contextName) && (Strings.isNullOrEmpty(this.targetContainerName) || !this.getZooKeeper().isConnected())) {
            System.out.println("You need to either specify a valid cloud service and a node id or a valid target fabric container name.");
            System.out.println("To use the target container name option you need to be connected to fabric.");
            return false;
        }
        if (!this.flush && Strings.isNullOrEmpty(this.sourceCidr) && Strings.isNullOrEmpty(this.sourceContainerName)) {
            System.out.println("You need to specify a source cidr or a source container name, unless you use the --flush option.");
            return false;
        }
        return true;
    }

    private Set<String> collectCirds() {
        LinkedHashSet<String> sourceCidrs = new LinkedHashSet<String>();
        if (!Strings.isNullOrEmpty(this.sourceCidr)) {
            sourceCidrs.add(this.sourceCidr);
        }
        if (this.getZooKeeper().isConnected() && !Strings.isNullOrEmpty(this.sourceContainerName)) {
            Container sourceContainer = this.fabricService.getContainer(this.sourceContainerName);
            if (sourceContainer != null && !Strings.isNullOrEmpty(sourceContainer.getPublicIp())) {
                sourceCidrs.add(sourceContainer.getPublicIp() + "/32");
            }
            if (sourceContainer != null && !Strings.isNullOrEmpty(sourceContainer.getLocalIp())) {
                sourceCidrs.add(sourceContainer.getLocalIp() + "/32");
            }
        }
        return sourceCidrs;
    }

    private ComputeService findTargetComputeService() {
        CreateJCloudsContainerMetadata metadata;
        if (!Strings.isNullOrEmpty(this.targetContainerName) && this.getZooKeeper().isConnected() && (metadata = this.getContainerCloudMetadata(this.targetContainerName)) != null) {
            CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)metadata.getCreateOptions();
            this.contextName = options.getContextName();
        }
        if (!Strings.isNullOrEmpty(this.contextName)) {
            for (ComputeService computeService : this.computeServices) {
                if (!computeService.getContext().unwrap().getName().equals(this.contextName)) continue;
                return computeService;
            }
        }
        if (this.computeServices == null || this.computeServices.size() == 0) {
            System.out.println("No compute services are available.");
            return null;
        }
        if (this.computeServices != null && this.computeServices.size() == 0) {
            return this.computeServices.get(0);
        }
        System.out.println("Multiple cloud provider service available. Please select one using the --provider option.");
        return null;
    }

    protected Object doExecute() throws Exception {
        if (this.validateArguments()) {
            CreateJCloudsContainerMetadata metadata;
            ComputeService computeService = this.findTargetComputeService();
            if (computeService == null) {
                return null;
            }
            Set<String> sourceCidrs = this.collectCirds();
            FirewallManager firewallManager = this.firewallManagerFactory.getFirewallManager(computeService);
            NodeMetadata node = null;
            if (!Strings.isNullOrEmpty(this.targetContainerName) && this.getZooKeeper().isConnected() && this.fabricService != null && (metadata = this.getContainerCloudMetadata(this.targetContainerName)) != null && !Strings.isNullOrEmpty(metadata.getNodeId())) {
                this.targetNodeId = metadata.getNodeId();
            }
            if (!Strings.isNullOrEmpty(this.targetNodeId)) {
                node = computeService.getNodeMetadata(this.targetNodeId);
            }
            if (node == null) {
                System.err.println("Could not find target node. Make sure you specified either --target-node-id or --target-container using a valid cloud container.");
                return null;
            }
            if (this.flush) {
                firewallManager.addRule(Rule.create().destination(node).flush());
                return null;
            }
            for (String cidr : sourceCidrs) {
                Rule rule = Rule.create().destination(node).source(cidr);
                if (this.port != null && this.port.length > 0) {
                    rule = rule.ports(this.port);
                }
                if (this.revoke) {
                    firewallManager.addRule(rule.revoke());
                    continue;
                }
                firewallManager.addRule(rule);
            }
        }
        return null;
    }

    private CreateJCloudsContainerMetadata getContainerCloudMetadata(String name) {
        CreateContainerMetadata metadata;
        Container targetContainer;
        if (!Strings.isNullOrEmpty(this.targetContainerName) && this.getZooKeeper().isConnected() && this.fabricService != null && (targetContainer = this.fabricService.getContainer(this.targetContainerName)) != null && targetContainer.getMetadata() != null && CreateJCloudsContainerMetadata.class.isAssignableFrom((metadata = targetContainer.getMetadata()).getClass())) {
            return (CreateJCloudsContainerMetadata)metadata;
        }
        return null;
    }

    public FirewallManagerFactory getFirewallManagerFactory() {
        return this.firewallManagerFactory;
    }

    public void setFirewallManagerFactory(FirewallManagerFactory firewallManagerFactory) {
        this.firewallManagerFactory = firewallManagerFactory;
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }
}

