/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateRemoteContainerOptions;
import org.fusesource.fabric.api.CreateSshContainerMetadata;
import org.fusesource.fabric.api.CreateSshContainerOptions;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.internal.ContainerProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshContainerProvider
implements ContainerProvider<CreateSshContainerOptions, CreateSshContainerMetadata> {
    private static final Logger logger = LoggerFactory.getLogger(SshContainerProvider.class);
    private boolean verbose = false;

    @Override
    public Set<CreateSshContainerMetadata> create(CreateSshContainerOptions options) {
        LinkedHashSet<CreateSshContainerMetadata> result = new LinkedHashSet<CreateSshContainerMetadata>();
        try {
            String path = options.getPath();
            String host = options.getHost();
            String ip = InetAddress.getByName(host).getHostAddress();
            options.setPreferredAddress(ip);
            if (options.getProviderURI() != null && options.getProviderURI().getQuery() != null) {
                this.verbose = options.getProviderURI().getQuery().contains("verbose");
            }
            if (host == null) {
                throw new IllegalArgumentException("host name must be specified in uri '" + options.getProviderURI() + "'");
            }
            int port = options.getPort();
            if (port == -1) {
                port = 22;
            }
            String originalName = new String(options.getName());
            for (int i = 1; i <= options.getNumber(); ++i) {
                String containerName = options.getNumber() > 1 ? originalName + i : originalName;
                CreateSshContainerMetadata metadata = new CreateSshContainerMetadata();
                metadata.setCreateOptions(options);
                metadata.setContainerName(containerName);
                String script = ContainerProviderUtils.buildInstallAndStartScript((CreateRemoteContainerOptions)options.name(containerName));
                logger.debug("Running script on host {}:\n{}", (Object)host, (Object)script);
                try {
                    this.runScriptOnHost(options, script);
                }
                catch (Throwable ex) {
                    metadata.setFailure(ex);
                }
                result.add(metadata);
            }
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
        return result;
    }

    @Override
    public void start(Container container) {
        CreateContainerMetadata<?> metadata = container.getMetadata();
        if (!(metadata instanceof CreateSshContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateSshContainerMetadata sshContainerMetadata = (CreateSshContainerMetadata)metadata;
        CreateSshContainerOptions options = (CreateSshContainerOptions)sshContainerMetadata.getCreateOptions();
        try {
            String script = ContainerProviderUtils.buildStartScript(options.name(container.getId()));
            this.runScriptOnHost(options, script);
        }
        catch (Throwable t) {
            logger.error("Failed to start container: " + container.getId(), t);
        }
    }

    @Override
    public void stop(Container container) {
        CreateContainerMetadata<?> metadata = container.getMetadata();
        if (!(metadata instanceof CreateSshContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateSshContainerMetadata sshContainerMetadata = (CreateSshContainerMetadata)metadata;
        CreateSshContainerOptions options = (CreateSshContainerOptions)sshContainerMetadata.getCreateOptions();
        try {
            String script = ContainerProviderUtils.buildStopScript(options.name(container.getId()));
            this.runScriptOnHost(options, script);
        }
        catch (Throwable t) {
            logger.error("Failed to stop container: " + container.getId(), t);
        }
    }

    @Override
    public void destroy(Container container) {
        CreateContainerMetadata<?> metadata = container.getMetadata();
        if (!(metadata instanceof CreateSshContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateSshContainerMetadata sshContainerMetadata = (CreateSshContainerMetadata)metadata;
        CreateSshContainerOptions options = (CreateSshContainerOptions)sshContainerMetadata.getCreateOptions();
        try {
            String script = ContainerProviderUtils.buildUninstallScript(options.name(container.getId()));
            this.runScriptOnHost(options, script);
        }
        catch (Throwable t) {
            logger.error("Failed to stop container: " + container.getId(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScriptOnHost(CreateSshContainerOptions options, String script) throws Exception {
        Session session = null;
        Exception connectException = null;
        for (int i = 0; i <= options.getSshRetries(); ++i) {
            if (i > 0) {
                long delayMs = (long)(200.0 * Math.pow(i, 2.0));
                Thread.sleep(delayMs);
            }
            try {
                byte[] passPhrase;
                JSch jsch = new JSch();
                byte[] privateKey = this.readFile(options.getPrivateKeyFile());
                byte[] byArray = passPhrase = options.getPassPhrase() != null ? options.getPassPhrase().getBytes() : null;
                if (privateKey != null && options.getPassword() == null) {
                    jsch.addIdentity(options.getUsername(), privateKey, null, passPhrase);
                    session = jsch.getSession(options.getUsername(), options.getHost(), options.getPort().intValue());
                } else {
                    session = jsch.getSession(options.getUsername(), options.getHost(), options.getPort().intValue());
                    session.setPassword(options.getPassword());
                }
                session.setTimeout(60000);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect();
                connectException = null;
                break;
            }
            catch (Exception from) {
                connectException = from;
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
                session = null;
                continue;
            }
        }
        if (connectException != null) {
            throw connectException;
        }
        ChannelExec executor = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        try {
            executor = (ChannelExec)session.openChannel("exec");
            executor.setPty(true);
            executor.setCommand(script);
            executor.setOutputStream((OutputStream)output);
            executor.setErrStream((OutputStream)error);
            executor.connect();
            int errorStatus = -1;
            int i = 0;
            while (!executor.isClosed()) {
                if (i > 0) {
                    long delayMs = (long)(200.0 * Math.pow(i, 2.0));
                    Thread.sleep(delayMs);
                }
                if ((errorStatus = executor.getExitStatus()) != -1) break;
                ++i;
            }
            logger.debug("Output: {}", (Object)output.toString());
            logger.debug("Error:  {}", (Object)error.toString());
            if (this.verbose) {
                System.out.println("Output : " + output.toString());
                System.out.println("Error : " + error.toString());
            }
            if (errorStatus != 0) {
                throw new Exception(String.format("%s@%s:%d: received exit status %d executing \n--- command ---\n%s\n--- output ---\n%s\n--- error ---\n%s\n------\n", options.getUsername(), options.getHost(), options.getPort(), executor.getExitStatus(), script, output.toString(), error.toString()));
            }
        }
        finally {
            if (executor != null) {
                executor.disconnect();
            }
            session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String path) {
        byte[] bytes = null;
        FileInputStream fin = null;
        File file = new File(path);
        if (path != null && file.exists()) {
            try {
                fin = new FileInputStream(file);
                bytes = new byte[(int)file.length()];
                fin.read(bytes);
            }
            catch (IOException e) {
                logger.warn("Error reading file {}.", (Object)path);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return bytes;
    }
}

