/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.jclouds.compute.ComputeService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudUtils.class);
    private static final String FACTORY_FILTER = "(service.factoryPid=%s)";

    private CloudUtils() {
    }

    public static Map<String, String> parseProviderOptions(String[] options) {
        HashMap<String, String> providerOptions = new HashMap<String, String>();
        if (options != null && options.length > 0) {
            for (String option : options) {
                if (!option.contains("=")) continue;
                String key = option.substring(0, option.indexOf("="));
                String value = option.substring(option.lastIndexOf("=") + 1);
                providerOptions.put(key, value);
            }
        }
        return providerOptions;
    }

    public static void registerProvider(final IZKClient zooKeeper, final ConfigurationAdmin configurationAdmin, final String name, final String provider, final String identity, final String credential, final Map<String, String> props) throws Exception {
        Runnable registrationTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Configuration configuration = CloudUtils.findOrCreateFactoryConfiguration(configurationAdmin, "org.jclouds.compute", name, provider, null);
                    if (configuration != null) {
                        String value;
                        String key;
                        Dictionary dictionary = configuration.getProperties();
                        if (dictionary == null) {
                            dictionary = new Properties();
                        }
                        dictionary.put("name", name);
                        dictionary.put("provider", provider);
                        dictionary.put("credential", credential);
                        dictionary.put("identity", identity);
                        dictionary.put("credential-store", "zookeeper");
                        dictionary.put("jclouds.ssh.max-retries", "40");
                        if (provider != null && provider.equals("aws-ec2") && props != null && props.containsKey("owner") && props.get("owner") != null) {
                            dictionary.put("jclouds.ec2.ami-owners", props.get("owner"));
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            key = (String)entry.getKey();
                            value = (String)entry.getValue();
                            dictionary.put(key, value);
                        }
                        configuration.update(dictionary);
                        if (zooKeeper.isConnected()) {
                            if (zooKeeper.exists(ZkPath.CLOUD_SERVICE.getPath(name)) == null) {
                                ZooKeeperUtils.create(zooKeeper, ZkPath.CLOUD_SERVICE.getPath(name));
                            }
                            for (Map.Entry entry : props.entrySet()) {
                                key = (String)entry.getKey();
                                value = (String)entry.getValue();
                                if (key.equals("service.pid") || key.equals("service.factoryPid")) continue;
                                ZooKeeperUtils.set(zooKeeper, ZkPath.CLOUD_SERVICE_PROPERTY.getPath(name, key), value);
                            }
                        } else {
                            System.out.println("Fabric has not been initialized. Provider registration will be local to the current container.");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(registrationTask).start();
    }

    public static void registerApi(final IZKClient zooKeeper, final ConfigurationAdmin configurationAdmin, final String name, final String api, final String endpoint, final String identity, final String credential, final Map<String, String> props) throws Exception {
        Runnable registrationTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Configuration configuration = CloudUtils.findOrCreateFactoryConfiguration(configurationAdmin, "org.jclouds.compute", name, null, api);
                    if (configuration != null) {
                        String value;
                        String key;
                        Dictionary dictionary = configuration.getProperties();
                        if (dictionary == null) {
                            dictionary = new Properties();
                        }
                        dictionary.put("name", name);
                        dictionary.put("api", api);
                        dictionary.put("endpoint", endpoint);
                        dictionary.put("credential", credential);
                        dictionary.put("identity", identity);
                        dictionary.put("credential-store", "zookeeper");
                        dictionary.put("jclouds.ssh.max-retries", "40");
                        if (api != null && api.equals("aws-ec2") && props != null && props.containsKey("owner") && props.get("owner") != null) {
                            dictionary.put("jclouds.ec2.ami-owners", props.get("owner"));
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            key = (String)entry.getKey();
                            value = (String)entry.getValue();
                            dictionary.put(key, value);
                        }
                        configuration.update(dictionary);
                        if (zooKeeper.isConnected()) {
                            if (zooKeeper.exists(ZkPath.CLOUD_SERVICE.getPath(name)) == null) {
                                ZooKeeperUtils.create(zooKeeper, ZkPath.CLOUD_SERVICE.getPath(name));
                            }
                            for (Map.Entry entry : props.entrySet()) {
                                key = (String)entry.getKey();
                                value = (String)entry.getValue();
                                if (key.equals("service.pid") || key.equals("service.factoryPid")) continue;
                                ZooKeeperUtils.set(zooKeeper, ZkPath.CLOUD_SERVICE_PROPERTY.getPath(name, key), value);
                            }
                        } else {
                            System.out.println("Fabric has not been initialized. Provider registration will be local to the current container.");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(registrationTask).start();
    }

    private static Configuration findOrCreateFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String name, String provider, String api) throws IOException {
        Configuration configuration = null;
        if (configurationAdmin != null) {
            try {
                Configuration[] configurations = configurationAdmin.listConfigurations(String.format(FACTORY_FILTER, factoryPid));
                if (configurations != null) {
                    for (Configuration conf : configurations) {
                        Dictionary dictionary = conf.getProperties();
                        if (dictionary != null && name != null) {
                            if (!name.equals(dictionary.get("name"))) continue;
                            return conf;
                        }
                        if (dictionary != null && provider != null && provider.equals(dictionary.get("provider"))) {
                            return conf;
                        }
                        if (dictionary == null || api == null || !api.equals(dictionary.get("api"))) continue;
                        return conf;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to lookup configuration admin for existing cloud providers.", (Throwable)e);
            }
            LOGGER.debug("No configuration found with factoryPid org.jclouds.compute. Creating new one.");
            configuration = configurationAdmin.createFactoryConfiguration(factoryPid, null);
        }
        return configuration;
    }

    public static synchronized ComputeService waitForComputeService(BundleContext bundleContext, String name) {
        ComputeService computeService = null;
        try {
            for (int r = 0; r < 6; ++r) {
                ServiceReference[] references = bundleContext.getAllServiceReferences(ComputeService.class.getName(), "(name=" + name + ")");
                if (references != null && references.length > 0) {
                    computeService = (ComputeService)bundleContext.getService(references[0]);
                    return computeService;
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while waiting for service.", (Throwable)e);
        }
        return computeService;
    }
}

