/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.service.jclouds.internal.CloudUtils;
import org.jclouds.karaf.utils.EnvHelper;

@Command(name="cloud-service-add", scope="fabric", description="Registers a cloud provider with the fabric.")
public class CloudServiceAdd
extends FabricCommand {
    @Option(name="--name", required=false, description="The service context name. Used to distinct between multiple service of the same provider/api.")
    protected String contextName;
    @Option(name="--provider", required=false, description="The cloud provider name. Example: aws-ec2.")
    private String provider;
    @Option(name="--api", required=false, description="The cloud api name. Example: openstack, cloudstack.")
    private String api;
    @Option(name="--endpoint", required=false, description="The cloud endpoint.")
    private String endpoint;
    @Option(name="--identity", required=false, description="The identity used to access the cloud provider.")
    private String identity;
    @Option(name="--credential", required=false, description="The credential used to access the cloud provider.")
    private String credential;
    @Option(name="--async-registration", required=false, description="Do not wait for the provider registration.")
    private Boolean registerAsync = false;
    @Option(name="--owner", required=false, description="EC2 AMI owner.")
    private String owner;
    @Option(name="--option", required=false, multiValued=true, description="Provider specific properties. Example: --option jclouds.regions=us-east-1.")
    private String[] options;

    @Override
    protected Object doExecute() throws Exception {
        String serviceName = null;
        String providerValue = EnvHelper.getComputeProvider(this.provider);
        String apiValue = EnvHelper.getBlobStoreApi(this.api);
        String endpointValue = EnvHelper.getComputeEndpoint(this.endpoint);
        String identityValue = EnvHelper.getComputeIdentity(this.identity);
        String credentialValue = EnvHelper.getComputeCredential(this.credential);
        if (this.contextName == null && providerValue != null) {
            this.contextName = providerValue;
        } else if (this.contextName == null && apiValue != null) {
            this.contextName = apiValue;
        }
        Map<String, String> props = CloudUtils.parseProviderOptions(this.options);
        if (this.options != null && this.options.length > 1) {
            for (String option : this.options) {
                if (!option.contains("=")) continue;
                String key = option.substring(0, option.indexOf("="));
                String value = option.substring(option.lastIndexOf("=") + 1);
                props.put(key, value);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.owner)) {
            props.put("owner", this.owner);
        }
        if (Strings.isNullOrEmpty((String)providerValue) && Strings.isNullOrEmpty((String)apiValue)) {
            System.out.println("Need to specify at least a provider or an api as an option (--provider or --api) or as an environmental variable.");
            System.out.println("Supported environmental variables for provider and api are JCLOUDS_COMPUTE_PROVIDER JCLOUDS_COMPUTE_API respectively.");
            return null;
        }
        if (Strings.isNullOrEmpty((String)providerValue) && !Strings.isNullOrEmpty((String)apiValue) && Strings.isNullOrEmpty((String)endpointValue)) {
            System.out.println("You specified an api but no endpoint is found. To use an api, you need an endpoint as option or as environmental variable");
            return null;
        }
        if (!Strings.isNullOrEmpty((String)providerValue) && (Strings.isNullOrEmpty((String)apiValue) || Strings.isNullOrEmpty((String)endpointValue))) {
            serviceName = providerValue;
            CloudUtils.registerProvider(this.getZooKeeper(), this.configurationAdmin, this.contextName, providerValue, identityValue, credentialValue, props);
        } else if (Strings.isNullOrEmpty((String)providerValue) && !Strings.isNullOrEmpty((String)apiValue) && !Strings.isNullOrEmpty((String)endpointValue)) {
            serviceName = apiValue;
            CloudUtils.registerApi(this.getZooKeeper(), this.configurationAdmin, this.contextName, apiValue, endpointValue, identityValue, credentialValue, props);
        } else if (Strings.isNullOrEmpty((String)this.api)) {
            serviceName = apiValue;
            CloudUtils.registerApi(this.getZooKeeper(), this.configurationAdmin, this.contextName, apiValue, endpointValue, identityValue, credentialValue, props);
        } else {
            serviceName = providerValue;
            CloudUtils.registerProvider(this.getZooKeeper(), this.configurationAdmin, this.contextName, providerValue, identityValue, credentialValue, props);
        }
        if (!this.registerAsync.booleanValue()) {
            System.out.println("Waiting for " + serviceName + " service to initialize.");
            CloudUtils.waitForComputeService(this.bundleContext, this.contextName);
        }
        return null;
    }
}

