/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.FabricStatus;
import org.fusesource.fabric.api.ProfileStatus;
import org.fusesource.fabric.service.HealthCheckMBean;
import org.fusesource.fabric.service.HealthStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck
implements HealthCheckMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(HealthCheck.class);
    private final FabricService fabricService;
    private NumberFormat percentInstance = NumberFormat.getPercentInstance();
    private ObjectName objectName;

    public HealthCheck(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("org.fusesource.fabric:type=Health");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            ObjectInstance objectInstance = mbeanServer.registerMBean(this, name);
        }
        catch (Exception e) {
            LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                mbeanServer.unregisterMBean(name);
            }
            catch (Exception e) {
                LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    @Override
    public List<HealthStatus> healthList() {
        ArrayList<HealthStatus> answer = new ArrayList<HealthStatus>();
        FabricStatus status = this.fabricService.getFabricStatus();
        Collection<ProfileStatus> statuses = status.getProfileStatusMap().values();
        for (ProfileStatus profile : statuses) {
            String id = profile.getProfile();
            int instances = profile.getCount();
            Integer minimum = profile.getMinimumInstances();
            Integer maximum = profile.getMaximumInstances();
            double healthPercent = profile.getHealth(instances);
            String level = "INFO";
            String message = "Profile " + id + " has health " + this.percentInstance.format(healthPercent);
            if (minimum != null) {
                if (instances <= 0) {
                    level = "ERROR";
                    message = "Profile " + id + " has no instances running! Should have at least " + minimum;
                } else if (instances < minimum) {
                    level = "WARNING";
                    message = "Profile " + id + " needs more instances running. Should have at least " + minimum + " but currently has only " + instances;
                }
            }
            if (maximum != null && level.equals("INFO") && instances > maximum) {
                level = "WARNING";
                message = "Profile " + id + " has too many instances running. Should have at most " + maximum + " but currently has only " + instances;
            }
            answer.add(new HealthStatus("org.fusesource.fabric.profileHealth", id, level, message, instances, minimum, maximum, healthPercent));
        }
        return answer;
    }
}

