/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.CreateEnsembleOptions;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.utils.BundleUtils;
import org.fusesource.fabric.utils.HostUtils;
import org.fusesource.fabric.utils.PortUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.internal.OsgiZkClient;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.fusesource.fabric.zookeeper.utils.ZookeeperImportUtils;
import org.linkedin.util.clock.Timespan;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClusterServiceImpl
implements ZooKeeperClusterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterServiceImpl.class);
    private static final String FRAMEWORK_VERSION = "mvn:org.apache.felix/org.apache.felix.framework/" + FabricConstants.FRAMEWORK_VERSION;
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private String version = "1.0";
    private boolean ensembleAutoStart = Boolean.parseBoolean(System.getProperty("ensemble.auto.start"));

    public void init() {
        if (this.ensembleAutoStart) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ZooKeeperClusterServiceImpl.this.createLocalServer();
                }
            }).start();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void createLocalServer() {
        this.createLocalServer(2181);
    }

    public void createLocalServer(int port) {
        String newUser = null;
        String newUserPassword = null;
        AbstractMap userProps = null;
        try {
            userProps = new org.apache.felix.utils.properties.Properties(new File(System.getProperty("karaf.home") + "/etc/users.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load users from etc/users.proprties. No users will be imported.", (Throwable)e);
        }
        if (userProps != null && !userProps.isEmpty()) {
            newUser = (String)userProps.keySet().iterator().next();
            newUserPassword = (String)userProps.get(newUser);
            this.createLocalServer(port, CreateEnsembleOptions.build().user(newUser, newUserPassword));
        } else {
            this.createLocalServer(port, CreateEnsembleOptions.build());
        }
    }

    public void createLocalServer(int port, CreateEnsembleOptions options) {
        try {
            String karafName = System.getProperty("karaf.name");
            String minimumPort = System.getProperty("minimum.port");
            String maximumPort = System.getProperty("maximum.port");
            int mappedPort = PortUtils.mapPortToRange(port, minimumPort, maximumPort);
            if (options.getZookeeperPassword() == null) {
                if (System.getProperties().containsKey("zookeeper.password")) {
                    options.setZookeeperPassword(System.getProperty("zookeeper.password"));
                } else {
                    options.setZookeeperPassword(ZooKeeperUtils.generatePassword());
                }
            }
            Bundle bundleFabricAgent = BundleUtils.findAndStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-agent");
            Bundle bundleFabricConfigAdmin = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-configadmin", "mvn:org.fusesource.fabric/fabric-configadmin/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricZooKeeper = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-zookeeper", "mvn:org.fusesource.fabric/fabric-zookeeper/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricJaas = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-jaas  ", "mvn:org.fusesource.fabric/fabric-jaas/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricCommands = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands  ", "mvn:org.fusesource.fabric/fabric-commands/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricMavenProxy = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands  ", "mvn:org.fusesource.fabric/fabric-maven-proxy/" + FabricConstants.FABRIC_VERSION);
            String connectionUrl = HostUtils.getLocalHostName() + ":" + Integer.toString(mappedPort);
            String autoImportFrom = System.getProperty("profiles.auto.import.path");
            Configuration config = this.configurationAdmin.createFactoryConfiguration("org.fusesource.fabric.zookeeper.server");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (autoImportFrom != null) {
                this.loadPropertiesFrom(properties, autoImportFrom + "/fabric/configs/versions/1.0/profiles/default/org.fusesource.fabric.zookeeper.server.properties");
            }
            properties.put("tickTime", "2000");
            properties.put("initLimit", "10");
            properties.put("syncLimit", "5");
            properties.put("dataDir", "data/zookeeper/0000");
            properties.put("clientPort", Integer.toString(mappedPort));
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper.server-0000");
            config.setBundleLocation(null);
            config.update(properties);
            config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
            properties = new Hashtable();
            if (autoImportFrom != null) {
                this.loadPropertiesFrom(properties, autoImportFrom + "/fabric/configs/versions/1.0/profiles/default/org.fusesource.fabric.zookeeper.properties");
            }
            properties.put("zookeeper.url", connectionUrl);
            properties.put("zookeeper.timeout", System.getProperties().containsKey("zookeeper.timeout") ? System.getProperties().getProperty("zookeeper.timeout") : "30000");
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper");
            properties.put("zookeeper.password", options.getZookeeperPassword());
            config.setBundleLocation(null);
            config.update(properties);
            bundleFabricZooKeeper.start();
            ServiceTracker tracker = new ServiceTracker(this.bundleContext, IZKClient.class.getName(), null);
            tracker.open();
            IZKClient client = (IZKClient)tracker.waitForService(5000L);
            if (client == null) {
                throw new IllegalStateException("Timeout waiting for ZooKeeper client to be registered");
            }
            tracker.close();
            client.waitForConnected();
            if (autoImportFrom != null) {
                ZookeeperImportUtils.importFromFileSystem(client, autoImportFrom, "/", null, null, false, false, false);
            }
            String defaultProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "default");
            ZooKeeperClusterServiceImpl.setConfigProperty(client, defaultProfile + "/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + karafName + "/ip}:" + Integer.toString(mappedPort));
            ZooKeeperClusterServiceImpl.setConfigProperty(client, defaultProfile + "/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", options.getZookeeperPassword());
            ZooKeeperUtils.set(client, ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "fabric-ensemble-0000"), "abstract=true\nhidden=true");
            String profileNode = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "fabric-ensemble-0000") + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            Properties p = new Properties();
            p.put("tickTime", "2000");
            p.put("initLimit", "10");
            p.put("syncLimit", "5");
            p.put("dataDir", "data/zookeeper/0000");
            this.loadPropertiesFrom(p, autoImportFrom + "/fabric/configs/versions/1.0/profiles/default/org.fusesource.fabric.zookeeper.server.properties");
            ZooKeeperUtils.set(client, profileNode, ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.set(client, ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "fabric-ensemble-0000-1"), "parents=fabric-ensemble-0000\nhidden=true");
            profileNode = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "fabric-ensemble-0000-1") + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            p = new Properties();
            p.put("clientPort", String.valueOf(mappedPort));
            ZooKeeperUtils.set(client, profileNode, ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.set(client, "/fabric/configs/versions/" + this.version + "/general/fabric-ensemble", "0000");
            ZooKeeperUtils.set(client, "/fabric/configs/versions/" + this.version + "/general/fabric-ensemble/0000", karafName);
            String fabricProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "fabric");
            ZooKeeperUtils.createDefault(client, fabricProfile, "default");
            p = ZooKeeperClusterServiceImpl.getProperties(client, fabricProfile + "/org.fusesource.fabric.agent.properties", new Properties());
            p.put("feature.fabric-commands", "fabric-commands");
            ZooKeeperUtils.set(client, fabricProfile + "/org.fusesource.fabric.agent.properties", ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.createDefault(client, ZkPath.CONFIG_CONTAINER.getPath(karafName), this.version);
            String assignedProfile = System.getProperty("profile");
            if (assignedProfile != null && !assignedProfile.isEmpty() && !"fabric".equals(assignedProfile)) {
                ZooKeeperUtils.createDefault(client, ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(this.version, karafName), "fabric fabric-ensemble-0000-1 " + assignedProfile);
            } else {
                ZooKeeperUtils.createDefault(client, ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(this.version, karafName), "fabric fabric-ensemble-0000-1");
            }
            ZooKeeperUtils.createDefault(client, defaultProfile + "/org.fusesource.fabric.jaas/encryption.enabled", "${zk:/fabric/authentication/encryption.enabled}");
            ZooKeeperUtils.createDefault(client, "/fabric/authentication/encryption.enabled", "true");
            ZooKeeperUtils.createDefault(client, "/fabric/authentication/domain", "karaf");
            this.addUsersToZookeeper(client, options.getUsers());
            client.fixACLs("/", true);
            if (this.ensembleAutoStart) {
                System.setProperty("ensemble.auto.start", Boolean.FALSE.toString());
                File file = new File(System.getProperty("karaf.base") + "/etc/system.properties");
                org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file);
                props.put("ensemble.auto.start", Boolean.FALSE.toString());
                props.save();
            }
            bundleFabricConfigAdmin.start();
            bundleFabricJaas.start();
            bundleFabricCommands.start();
            bundleFabricMavenProxy.start();
            if (!System.getProperties().containsKey("agent.auto.start") || Boolean.parseBoolean(System.getProperty("agent.auto.start"))) {
                bundleFabricAgent = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-agent  ", "mvn:org.fusesource.fabric/fabric-agent/" + FabricConstants.FABRIC_VERSION);
                bundleFabricAgent.start();
            }
        }
        catch (Exception e) {
            throw new FabricException("Unable to create zookeeper server configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Hashtable hashtable, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                hashtable.put(key, properties.get(key));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void clean() {
        try {
            Configuration[] configs;
            while ((configs = this.configurationAdmin.listConfigurations("(|(service.factoryPid=org.fusesource.fabric.zookeeper.server)(service.pid=org.fusesource.fabric.zookeeper))")) != null && configs.length > 0) {
                for (Configuration config : configs) {
                    config.delete();
                }
                Thread.sleep(100L);
            }
            File zkDir = new File("data/zookeeper");
            if (zkDir.isDirectory()) {
                File newZkDir = new File("data/zookeeper." + System.currentTimeMillis());
                if (!zkDir.renameTo(newZkDir)) {
                    newZkDir = zkDir;
                }
                ZooKeeperClusterServiceImpl.delete(newZkDir);
            }
        }
        catch (Exception e) {
            throw new FabricException("Unable to delete zookeeper configuration", e);
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterServiceImpl.delete(child);
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    @Override
    public List<String> getEnsembleContainers() {
        try {
            Configuration[] configs = this.configurationAdmin.listConfigurations("(service.pid=org.fusesource.fabric.zookeeper)");
            if (configs == null || configs.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            if (this.zooKeeper.exists("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble") != null) {
                String clusterId = this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble");
                String containers = this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble/" + clusterId);
                Collections.addAll(list, containers.split(","));
            }
            return list;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper quorum containers", e);
        }
    }

    @Override
    public String getZooKeeperUrl() {
        try {
            Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
            String zooKeeperUrl = (String)config.getProperties().get("zookeeper.url");
            if (zooKeeperUrl == null) {
                throw new IllegalStateException("Unable to find the zookeeper url");
            }
            return zooKeeperUrl;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper current url", e);
        }
    }

    @Override
    public void createCluster(List<String> containers) {
        this.createCluster(containers, CreateEnsembleOptions.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCluster(List<String> containers, CreateEnsembleOptions options) {
        block23: {
            try {
                String zooKeeperUrl;
                if (options.getZookeeperPassword() == null) {
                    if (System.getProperties().containsKey("zookeeper.password")) {
                        options.setZookeeperPassword(System.getProperty("zookeeper.password"));
                    } else {
                        options.setZookeeperPassword(ZooKeeperUtils.generatePassword());
                    }
                }
                if (containers == null || containers.size() == 2) {
                    throw new IllegalArgumentException("One or at least 3 containers must be used to create a zookeeper ensemble");
                }
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                String string = zooKeeperUrl = config != null && config.getProperties() != null ? (String)config.getProperties().get("zookeeper.url") : null;
                if (zooKeeperUrl == null) {
                    if (containers.size() != 1 || !containers.get(0).equals(System.getProperty("karaf.name"))) {
                        throw new FabricException("The first zookeeper cluster must be configured on this container only.");
                    }
                    this.createLocalServer(2181, options);
                    return;
                }
                String url = ZooKeeperUtils.getSubstitutedPath(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url");
                if (!url.equals(zooKeeperUrl)) {
                    throw new IllegalStateException("The zookeeper configuration is not properly backed in the zookeeper tree.");
                }
                for (String container : containers) {
                    if (this.zooKeeper.exists(ZkPath.CONTAINER_ALIVE.getPath(container)) != null) continue;
                    throw new FabricException("The container " + container + " is not alive");
                }
                HashMap<String, List<Integer>> usedPorts = new HashMap<String, List<Integer>>();
                String oldClusterId = ZooKeeperUtils.get(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/general/fabric-ensemble");
                if (oldClusterId != null) {
                    Properties p = ZooKeeperClusterServiceImpl.toProperties(this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + oldClusterId + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties"));
                    for (Object n : p.keySet()) {
                        String node = (String)n;
                        if (!node.startsWith("server.")) continue;
                        String data = ZooKeeperUtils.getSubstitutedPath(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + oldClusterId + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties#" + node);
                        this.addUsedPorts(usedPorts, data);
                    }
                    String datas = ZooKeeperUtils.getSubstitutedPath(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url");
                    for (String data : datas.split(",")) {
                        this.addUsedPorts(usedPorts, data);
                    }
                }
                String newClusterId = oldClusterId == null ? "0000" : new DecimalFormat("0000").format(Integer.parseInt(oldClusterId) + 1);
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONFIG_VERSIONS_PROFILE.getPath(this.version, "fabric-ensemble-" + newClusterId), "abstract=true\nhidden=true");
                String profileNode = "/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + newClusterId + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                Properties profileNodeProperties = new Properties();
                profileNodeProperties.put("tickTime", "2000");
                profileNodeProperties.put("initLimit", "10");
                profileNodeProperties.put("syncLimit", "5");
                profileNodeProperties.put("dataDir", "data/zookeeper/" + newClusterId);
                int index = 1;
                String connectionUrl = "";
                String realConnectionUrl = "";
                String containerList = "";
                for (String container : containers) {
                    String ip = ZooKeeperUtils.getSubstitutedPath(this.zooKeeper, ZkPath.CONTAINER_IP.getPath(container));
                    String minimumPort = ZooKeeperUtils.getSubstitutedPath(this.zooKeeper, ZkPath.CONTAINER_PORT_MIN.getPath(container));
                    String maximumPort = ZooKeeperUtils.getSubstitutedPath(this.zooKeeper, ZkPath.CONTAINER_PORT_MAX.getPath(container));
                    String profNode = "/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + newClusterId + "-" + Integer.toString(index);
                    String pidNode = profNode + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                    Properties pidNodeProperties = new Properties();
                    ZooKeeperUtils.set(this.zooKeeper, profNode, "parents=fabric-ensemble-" + newClusterId + "\nhidden=true");
                    String port1 = Integer.toString(this.findPort(usedPorts, ip, PortUtils.mapPortToRange(2181, minimumPort, maximumPort)));
                    if (containers.size() > 1) {
                        String port2 = Integer.toString(this.findPort(usedPorts, ip, PortUtils.mapPortToRange(2888, minimumPort, maximumPort)));
                        String port3 = Integer.toString(this.findPort(usedPorts, ip, PortUtils.mapPortToRange(3888, minimumPort, maximumPort)));
                        profileNodeProperties.put("server." + Integer.toString(index), "${zk:" + container + "/ip}:" + port2 + ":" + port3);
                        pidNodeProperties.put("server.id", Integer.toString(index));
                    }
                    pidNodeProperties.put("clientPort", port1);
                    ZooKeeperUtils.set(this.zooKeeper, pidNode, ZooKeeperClusterServiceImpl.toString(pidNodeProperties));
                    ZooKeeperUtils.add(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/containers/" + container, "fabric-ensemble-" + newClusterId + "-" + Integer.toString(index));
                    if (connectionUrl.length() > 0) {
                        connectionUrl = connectionUrl + ",";
                        realConnectionUrl = realConnectionUrl + ",";
                    }
                    connectionUrl = connectionUrl + "${zk:" + container + "/ip}:" + port1;
                    realConnectionUrl = realConnectionUrl + ip + ":" + port1;
                    if (containerList.length() > 0) {
                        containerList = containerList + ",";
                    }
                    containerList = containerList + container;
                    ++index;
                }
                ZooKeeperUtils.set(this.zooKeeper, profileNode, ZooKeeperClusterServiceImpl.toString(profileNodeProperties));
                if (oldClusterId != null) {
                    Properties properties = ZooKeeperUtils.getProperties(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties");
                    properties.put("zookeeper.url", realConnectionUrl);
                    properties.put("zookeeper.password", options.getZookeeperPassword());
                    OsgiZkClient dst = new OsgiZkClient();
                    dst.updated(properties);
                    try {
                        dst.waitForConnected(new Timespan(30L, Timespan.TimeUnit.SECOND));
                        ZooKeeperUtils.copy(this.zooKeeper, dst, "/fabric/registry");
                        ZooKeeperUtils.copy(this.zooKeeper, dst, "/fabric/authentication");
                        ZooKeeperUtils.copy(this.zooKeeper, dst, "/fabric/configs");
                        for (String container : containers) {
                            String alivePath = "/fabric/registry/containers/alive/" + container;
                            if (dst.exists(alivePath) == null) continue;
                            dst.deleteWithChildren(alivePath);
                        }
                        ZooKeeperUtils.set((IZKClient)dst, "/fabric/configs/versions/" + this.version + "/general/fabric-ensemble", newClusterId);
                        ZooKeeperUtils.set((IZKClient)dst, "/fabric/configs/versions/" + this.version + "/general/fabric-ensemble/" + newClusterId, containerList);
                        for (String container : dst.getChildren("/fabric/configs/versions/" + this.version + "/containers")) {
                            ZooKeeperUtils.remove(dst, "/fabric/configs/versions/" + this.version + "/containers/" + container, "fabric-ensemble-" + oldClusterId + "-.*");
                        }
                        ZooKeeperClusterServiceImpl.setConfigProperty(dst, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", options.getZookeeperPassword());
                        ZooKeeperClusterServiceImpl.setConfigProperty(dst, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
                        ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", options.getZookeeperPassword());
                        ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
                        break block23;
                    }
                    finally {
                        dst.close();
                    }
                }
                ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", options.getZookeeperPassword());
                ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
            }
            catch (Exception e) {
                throw new FabricException("Unable to create zookeeper quorum: " + e.getMessage(), e);
            }
        }
    }

    public static String toString(Properties source) throws IOException {
        StringWriter writer = new StringWriter();
        source.store(writer, null);
        return writer.toString();
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    public static Properties getProperties(IZKClient client, String file, Properties defaultValue) throws InterruptedException, KeeperException, IOException {
        try {
            String v = ZooKeeperUtils.get(client, file);
            if (v != null) {
                return ZooKeeperClusterServiceImpl.toProperties(v);
            }
            return defaultValue;
        }
        catch (KeeperException.NoNodeException e) {
            return defaultValue;
        }
    }

    public static void setConfigProperty(IZKClient client, String file, String prop, String value) throws InterruptedException, KeeperException, IOException {
        Properties p = ZooKeeperClusterServiceImpl.getProperties(client, file, new Properties());
        p.setProperty(prop, value);
        ZooKeeperUtils.set(client, file, ZooKeeperClusterServiceImpl.toString(p));
    }

    private int findPort(Map<String, List<Integer>> usedPorts, String ip, int port) {
        List<Integer> ports = usedPorts.get(ip);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(ip, ports);
        }
        while (true) {
            if (!ports.contains(port)) {
                ports.add(port);
                return port;
            }
            ++port;
        }
    }

    private void addUsedPorts(Map<String, List<Integer>> usedPorts, String data) {
        String[] parts = data.split(":");
        List<Integer> ports = usedPorts.get(parts[0]);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(parts[0], ports);
        }
        for (int i = 1; i < parts.length; ++i) {
            ports.add(Integer.parseInt(parts[i]));
        }
    }

    @Override
    public void addToCluster(List<String> containers) {
        try {
            List<String> current = this.getEnsembleContainers();
            current.addAll(containers);
            this.createCluster(current);
        }
        catch (Exception e) {
            throw new FabricException("Unable to add containers to fabric ensemble: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeFromCluster(List<String> containers) {
        try {
            List<String> current = this.getEnsembleContainers();
            current.removeAll(containers);
            this.createCluster(current);
        }
        catch (Exception e) {
            throw new FabricException("Unable to remove containers to fabric ensemble: " + e.getMessage(), e);
        }
    }

    private void addUsersToZookeeper(IZKClient zookeeper, Map<String, String> users) throws KeeperException, InterruptedException {
        Pattern p = Pattern.compile("(.+),(.+)");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("encryption.prefix", "{CRYPT}");
        options.put("encryption.suffix", "{CRYPT}");
        options.put("encryption.enabled", "true");
        options.put("encryption.enabled", "true");
        options.put("encryption.algorithm", "MD5");
        options.put("encryption.encoding", "hexadecimal");
        options.put(BundleContext.class.getName(), (String)this.bundleContext);
        EncryptionSupport encryptionSupport = new EncryptionSupport(options);
        Encryption encryption = encryptionSupport.getEncryption();
        StringBuilder sb = new StringBuilder();
        for (String user : users.keySet()) {
            Matcher m = p.matcher(users.get(user));
            if (!m.matches() || m.groupCount() < 2) continue;
            String password = m.group(1).trim();
            if (!password.startsWith(encryptionSupport.getEncryptionPrefix()) || !password.endsWith(encryptionSupport.getEncryptionSuffix())) {
                password = encryptionSupport.getEncryptionPrefix() + encryption.encryptPassword(m.group(1)).trim() + encryptionSupport.getEncryptionSuffix();
            }
            String role = m.group(2).trim();
            sb.append(user).append("=").append(password).append(",").append(role).append("\n");
        }
        String allUsers = sb.toString();
        ZooKeeperUtils.createDefault(zookeeper, "/fabric/authentication/users", allUsers);
    }
}

