/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.util.Properties;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.VersionSequence;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;

public class VersionImpl
implements Version {
    private final String name;
    private final FabricServiceImpl service;
    private final VersionSequence sequence;

    public VersionImpl(String name, FabricServiceImpl service) {
        this.name = name;
        this.service = service;
        this.sequence = new VersionSequence(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getAttributes() {
        try {
            String node = ZkPath.CONFIG_VERSION.getPath(this.name);
            Properties props = ZooKeeperUtils.getProperties(this.service.getZooKeeper(), node);
            return props;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setAttribute(String key, String value) {
        try {
            Properties props = this.getAttributes();
            if (value != null) {
                props.setProperty(key, value);
            } else {
                props.remove(key);
            }
            String node = ZkPath.CONFIG_VERSION.getPath(this.name);
            ZooKeeperUtils.setProperties(this.service.getZooKeeper(), node, props);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public VersionSequence getSequence() {
        return this.sequence;
    }

    @Override
    public int compareTo(Version that) {
        return this.sequence.compareTo(that.getSequence());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        return !(this.name != null ? !this.name.equals(version.name) : version.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public Version getDerivedFrom() {
        return null;
    }

    @Override
    public Profile[] getProfiles() {
        return this.service.getProfiles(this.name);
    }

    @Override
    public Profile getProfile(String name) {
        return this.service.getProfile(this.name, name);
    }

    @Override
    public Profile createProfile(String name) {
        return this.service.createProfile(this.name, name);
    }

    @Override
    public void delete() {
        this.service.deleteVersion(this.name);
    }

    public String toString() {
        return this.name;
    }
}

