/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundles {
    private static final transient Logger logger = LoggerFactory.getLogger(Bundles.class);

    public static void startBundle(BundleContext context, String containsName) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            String name = bundle.getSymbolicName();
            if (!name.contains(containsName)) continue;
            logger.debug("About to start bundle: " + name);
            try {
                bundle.start();
            }
            catch (Exception e) {
                logger.warn("Failed to start bundle: " + name + " due " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public static void stopBundle(BundleContext context, String containsName) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            String name = bundle.getSymbolicName();
            if (!name.contains(containsName)) continue;
            logger.debug("About to stop bundle: " + name);
            try {
                bundle.stop();
            }
            catch (Exception e) {
                logger.warn("Failed to stop bundle: " + name + " due " + e.getMessage() + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }
}

