/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.support;

import java.util.ArrayList;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

public abstract class ContainerUpgradeSupport
extends FabricCommand {
    protected Profile[] getProfilesForUpgradeOrRollback(Profile[] existingProfiles, Version targetVersion) {
        ArrayList<Profile> list = new ArrayList<Profile>(existingProfiles.length);
        for (Profile old : existingProfiles) {
            Profile newProfile = targetVersion.getProfile(old.getId());
            if (newProfile == null) {
                throw new IllegalArgumentException("Profile " + old.getId() + " with version " + targetVersion + " does not exists");
            }
            list.add(newProfile);
        }
        return list.toArray(new Profile[0]);
    }

    protected int canUpgrade(Version version, Container container) {
        Version current = container.getVersion();
        return version.compareTo(current);
    }

    protected int canRollback(Version version, Container container) {
        return this.canUpgrade(version, container) * -1;
    }
}

