/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreationStateListener;
import org.fusesource.fabric.api.NullCreationStateListener;

public class CreateContainerBasicOptions<T extends CreateContainerBasicOptions>
implements CreateContainerOptions {
    protected String name;
    protected String parent;
    protected String providerType;
    protected URI providerURI;
    protected boolean ensembleServer;
    protected String preferredAddress;
    protected String resolver = null;
    protected Integer minimumPort = 0;
    protected Integer maximumPort = 65535;
    protected final Map<String, Properties> systemProperties = new HashMap<String, Properties>();
    protected Integer number = 1;
    protected URI proxyUri;
    protected String zookeeperUrl;
    protected String zookeeperPassword;
    protected String jvmOpts;
    protected boolean adminAccess = false;
    protected Map<String, CreateContainerMetadata<T>> metadataMap = new HashMap<String, CreateContainerMetadata<T>>();
    private transient CreationStateListener creationStateListener = new NullCreationStateListener();

    protected Map<String, String> getParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.providerURI != null && this.providerURI.getQuery() != null) {
            String[] params;
            for (String param : params = this.providerURI.getQuery().split("&")) {
                String name = param.split("=")[0];
                String value = param.split("=")[1];
                map.put(name, value);
            }
        }
        return map;
    }

    public T preferredAddress(String preferredAddress) {
        this.setPreferredAddress(preferredAddress);
        return (T)this;
    }

    public T resolver(String resolver) {
        this.setResolver(resolver);
        return (T)this;
    }

    public T minimumPort(int minimumPort) {
        this.setMinimumPort(minimumPort);
        return (T)this;
    }

    public T maximumPort(int maximumPort) {
        this.setMaximumPort(maximumPort);
        return (T)this;
    }

    public T ensembleServer(boolean ensembleServer) {
        this.ensembleServer = ensembleServer;
        return (T)this;
    }

    public T number(int number) {
        this.number = number;
        return (T)this;
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T parent(String parent) {
        this.parent = parent;
        return (T)this;
    }

    public T providerType(String providerType) {
        this.providerType = providerType;
        return (T)this;
    }

    public T providerURI(URI providerURI) {
        this.providerURI = providerURI;
        return (T)this;
    }

    public T providerUri(String providerUri) throws URISyntaxException {
        this.providerURI = new URI(providerUri);
        return (T)this;
    }

    public T zookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
        return (T)this;
    }

    public T zookeeperPassword(String zookeeperPassword) {
        this.zookeeperPassword = zookeeperPassword;
        return (T)this;
    }

    public T proxyUri(URI proxyUri) {
        this.proxyUri = proxyUri;
        return (T)this;
    }

    public T proxyUri(String proxyUri) throws URISyntaxException {
        this.proxyUri = new URI(proxyUri);
        return (T)this;
    }

    public T jvmOpts(String jvmOpts) {
        this.jvmOpts = jvmOpts;
        return (T)this;
    }

    public T adminAccess(boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (T)this;
    }

    public T creationStateListener(CreationStateListener creationStateListener) {
        this.creationStateListener = creationStateListener;
        return (T)this;
    }

    @Override
    public String getProviderType() {
        return this.providerType != null ? this.providerType : (this.providerURI != null ? this.providerURI.getScheme() : null);
    }

    @Override
    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public URI getProviderURI() {
        return this.providerURI;
    }

    @Override
    public void setProviderURI(URI providerURI) {
        this.providerURI = providerURI;
    }

    @Override
    public boolean isEnsembleServer() {
        return this.ensembleServer;
    }

    @Override
    public void setEnsembleServer(boolean ensembleServer) {
        this.ensembleServer = ensembleServer;
    }

    @Override
    public String getPreferredAddress() {
        return this.preferredAddress;
    }

    @Override
    public void setPreferredAddress(String preferredAddress) {
        this.preferredAddress = preferredAddress;
    }

    @Override
    public String getResolver() {
        return this.getParameters().get("resolver") != null ? this.getParameters().get("resolver") : this.resolver;
    }

    @Override
    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    @Override
    public int getMinimumPort() {
        return this.minimumPort;
    }

    @Override
    public void setMinimumPort(int port) {
        this.minimumPort = port;
    }

    @Override
    public int getMaximumPort() {
        return this.maximumPort;
    }

    @Override
    public void setMaximumPort(int port) {
        this.maximumPort = port;
    }

    @Override
    public Map<String, Properties> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(Integer number) {
        this.number = number;
    }

    @Override
    public URI getProxyUri() {
        return this.proxyUri;
    }

    @Override
    public void setProxyUri(URI proxyUri) {
        this.proxyUri = proxyUri;
    }

    @Override
    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    @Override
    public void setZookeeperUrl(String zookeeperUrl) {
        this.zookeeperUrl = zookeeperUrl;
    }

    @Override
    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    @Override
    public void setZookeeperPassword(String zookeeperPassword) {
        this.zookeeperPassword = zookeeperPassword;
    }

    @Override
    public String getJvmOpts() {
        return this.jvmOpts;
    }

    @Override
    public void setJvmOpts(String jvmOpts) {
        this.jvmOpts = jvmOpts;
    }

    @Override
    public boolean isAdminAccess() {
        return this.adminAccess;
    }

    @Override
    public CreationStateListener getCreationStateListener() {
        return this.creationStateListener;
    }

    @Override
    public void setCreationStateListener(CreationStateListener creationStateListener) {
        this.creationStateListener = creationStateListener;
    }

    @Override
    public void setAdminAccess(boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public Map<String, CreateContainerMetadata<T>> getMetadataMap() {
        return this.metadataMap;
    }
}

