/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.utils.HostUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkDefs;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafContainerRegistration
implements LifecycleListener,
NotificationListener,
ConfigurationListener {
    private transient Logger logger = LoggerFactory.getLogger(KarafContainerRegistration.class);
    public static final String IP_REGEX = "([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}";
    public static final String HOST_REGEX = "[a-zA-Z][a-zA-Z0-9\\-\\.]*[a-zA-Z]";
    public static final String IP_OR_HOST_REGEX = "((([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3})|([a-zA-Z][a-zA-Z0-9\\-\\.]*[a-zA-Z])|0.0.0.0)";
    public static final String RMI_HOST_REGEX = "://((([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3})|([a-zA-Z][a-zA-Z0-9\\-\\.]*[a-zA-Z])|0.0.0.0)";
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private BundleContext bundleContext;
    private final Set<String> domains = new CopyOnWriteArraySet<String>();
    private volatile MBeanServer mbeanServer;
    private ReentrantLock lock = new ReentrantLock();

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        String name = System.getProperty("karaf.name");
        this.logger.trace("onConnected");
        try {
            String sshUrl;
            String jmxUrl;
            String domainsNode;
            this.lock.tryLock(10L, TimeUnit.SECONDS);
            String nodeAlive = ZkPath.CONTAINER_ALIVE.getPath(name);
            Stat stat = this.zooKeeper.exists(nodeAlive);
            if (stat != null) {
                if (stat.getEphemeralOwner() != this.zooKeeper.getSessionId()) {
                    this.zooKeeper.delete(nodeAlive);
                    this.zooKeeper.createWithParents(nodeAlive, CreateMode.EPHEMERAL);
                }
            } else {
                this.zooKeeper.createWithParents(nodeAlive, CreateMode.EPHEMERAL);
            }
            if ((stat = this.zooKeeper.exists(domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(name))) != null) {
                this.zooKeeper.deleteWithChildren(domainsNode);
            }
            if ((jmxUrl = this.getJmxUrl()) != null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_JMX.getPath(name), this.getJmxUrl(), CreateMode.PERSISTENT);
            }
            if ((sshUrl = this.getSshUrl()) != null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_SSH.getPath(name), this.getSshUrl(), CreateMode.PERSISTENT);
            }
            if (this.zooKeeper.exists(ZkPath.CONTAINER_RESOLVER.getPath(name)) == null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(name), KarafContainerRegistration.getContainerResolutionPolicy(this.zooKeeper, name), CreateMode.PERSISTENT);
            }
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(name), HostUtils.getLocalHostName(), CreateMode.PERSISTENT);
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_LOCAL_IP.getPath(name), HostUtils.getLocalIp(), CreateMode.PERSISTENT);
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_IP.getPath(name), KarafContainerRegistration.getContainerPointer(this.zooKeeper, name), CreateMode.PERSISTENT);
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                String address = System.getProperty(resolver);
                if (address == null || address.isEmpty() || this.zooKeeper.exists(ZkPath.CONTAINER_ADDRESS.getPath(name, resolver)) != null) continue;
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_ADDRESS.getPath(name, resolver), address, CreateMode.PERSISTENT);
            }
            String minimumPort = System.getProperty("minimum.port");
            String maximumPort = System.getProperty("maximum.port");
            if (this.zooKeeper.exists(ZkPath.CONTAINER_PORT_MIN.getPath(name)) == null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_PORT_MIN.getPath(name), minimumPort, CreateMode.PERSISTENT);
            }
            if (this.zooKeeper.exists(ZkPath.CONTAINER_PORT_MAX.getPath(name)) == null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_PORT_MAX.getPath(name), maximumPort, CreateMode.PERSISTENT);
            }
            String version = System.getProperty("fabric.version", "1.0");
            String profiles = System.getProperty("fabric.profiles");
            if (profiles != null) {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(name);
                String profileNode = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(version, name);
                if (this.zooKeeper.exists(versionNode) == null) {
                    this.zooKeeper.createOrSetWithParents(versionNode, version, CreateMode.PERSISTENT);
                }
                if (this.zooKeeper.exists(profileNode) == null) {
                    this.zooKeeper.createOrSetWithParents(profileNode, profiles, CreateMode.PERSISTENT);
                }
            }
            this.registerDomains();
        }
        catch (Exception e) {
            this.logger.warn("Error updating Fabric Container information. This exception will be ignored.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getJmxUrl() throws IOException {
        String name = System.getProperty("karaf.name");
        Configuration config = this.configurationAdmin.getConfiguration("org.apache.karaf.management");
        if (config.getProperties() != null) {
            String jmx = (String)config.getProperties().get("serviceUrl");
            jmx = KarafContainerRegistration.replaceJmxHost(jmx, "\\${zk:" + name + "/ip}");
            return jmx;
        }
        return null;
    }

    private String getSshUrl() throws IOException {
        String name = System.getProperty("karaf.name");
        Configuration config = this.configurationAdmin.getConfiguration("org.apache.karaf.shell");
        if (config != null && config.getProperties() != null) {
            String port = (String)config.getProperties().get("sshPort");
            return "${zk:" + name + "/ip}:" + port;
        }
        return null;
    }

    private static String getGlobalResolutionPolicy(IZKClient zookeeper) throws InterruptedException, KeeperException {
        String policy = "localhostname";
        List<String> validResoverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (zookeeper.exists(ZkPath.POLICIES.getPath("resolver")) != null) {
            policy = zookeeper.getStringData(ZkPath.POLICIES.getPath("resolver"));
        } else if (System.getProperty("global.resolver") != null && validResoverList.contains(System.getProperty("global.resolver"))) {
            policy = System.getProperty("global.resolver");
            zookeeper.createOrSetWithParents(ZkPath.POLICIES.getPath("resolver"), policy, CreateMode.PERSISTENT);
        }
        return policy;
    }

    private static String getContainerResolutionPolicy(IZKClient zookeeper, String container) throws InterruptedException, KeeperException {
        String policy = null;
        List<String> validResoverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (zookeeper.exists(ZkPath.CONTAINER_RESOLVER.getPath(container)) != null) {
            policy = zookeeper.getStringData(ZkPath.CONTAINER_RESOLVER.getPath(container));
        } else if (System.getProperty("local.resolver") != null && validResoverList.contains(System.getProperty("local.resolver"))) {
            policy = System.getProperty("local.resolver");
        }
        if (policy == null) {
            policy = KarafContainerRegistration.getGlobalResolutionPolicy(zookeeper);
        }
        if (policy != null && zookeeper.exists(ZkPath.CONTAINER_RESOLVER.getPath(container)) == null) {
            zookeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(container), policy, CreateMode.PERSISTENT);
        }
        return policy;
    }

    private static String getContainerPointer(IZKClient zookeeper, String container) throws InterruptedException, KeeperException {
        String pointer = "${zk:%s/%s}";
        String policy = KarafContainerRegistration.getContainerResolutionPolicy(zookeeper, container);
        return String.format(pointer, container, policy);
    }

    private static String getExternalAddresses(String host, String port) throws UnknownHostException, SocketException {
        InetAddress ip = InetAddress.getByName(host);
        if (ip.isAnyLocalAddress()) {
            return HostUtils.getLocalHostName() + ":" + port;
        }
        if (!ip.isLoopbackAddress()) {
            return ip.getHostName() + ":" + port;
        }
        return null;
    }

    public void destroy() {
        this.logger.trace("destroy");
        try {
            this.unregisterDomains();
        }
        catch (ServiceException e) {
            this.logger.trace("ZooKeeper is no longer available", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("An error occurred during disconnecting to zookeeper. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onDisconnected() {
        this.logger.trace("onDisconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMBeanServer(ServiceReference ref) {
        try {
            this.lock.lock();
            String name = System.getProperty("karaf.name");
            this.mbeanServer = (MBeanServer)this.bundleContext.getService(ref);
            if (this.mbeanServer != null) {
                this.mbeanServer.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, (Object)name);
                this.registerDomains();
            }
        }
        catch (Exception e) {
            this.logger.warn("An error occurred during mbean server registration. This exception will be ignored.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBeanServer(ServiceReference ref) {
        if (this.mbeanServer != null) {
            try {
                this.lock.lock();
                this.mbeanServer.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
                this.unregisterDomains();
            }
            catch (Exception e) {
                this.logger.warn("An error occurred during mbean server unregistration. This exception will be ignored.", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.mbeanServer = null;
        this.bundleContext.ungetService(ref);
    }

    protected void registerDomains() throws InterruptedException, KeeperException {
        if (this.isConnected() && this.mbeanServer != null) {
            String name = System.getProperty("karaf.name");
            this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
            for (String domain : this.mbeanServer.getDomains()) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_DOMAIN.getPath(name, domain), (byte[])null, CreateMode.PERSISTENT);
            }
        }
    }

    protected void unregisterDomains() throws InterruptedException, KeeperException {
        if (this.isConnected()) {
            String name = System.getProperty("karaf.name");
            String domainsPath = ZkPath.CONTAINER_DOMAINS.getPath(name);
            if (this.zooKeeper.exists(domainsPath) != null) {
                for (String child : this.zooKeeper.getChildren(domainsPath)) {
                    this.zooKeeper.delete(domainsPath + "/" + child);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notif, Object o) {
        this.logger.trace("handleNotification[{}]", (Object)notif);
        if (this.isConnected() && this.mbeanServer != null && notif instanceof MBeanServerNotification) {
            MBeanServerNotification notification = (MBeanServerNotification)notif;
            String domain = notification.getMBeanName().getDomain();
            String path = ZkPath.CONTAINER_DOMAIN.getPath((String)o, domain);
            try {
                this.lock.lock();
                if ("JMX.mbean.registered".equals(notification.getType())) {
                    if (this.domains.add(domain) && this.zooKeeper.exists(path) == null) {
                        this.zooKeeper.createOrSetWithParents(path, "", CreateMode.PERSISTENT);
                    }
                } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
                    this.domains.clear();
                    this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
                    if (!this.domains.contains(domain)) {
                        this.zooKeeper.delete(path);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Exception while jmx domain synchronization from event: " + notif + ". This exception will be ignored.", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static String replaceJmxHost(String jmxUrl, String hostName) {
        if (jmxUrl == null) {
            return null;
        }
        return jmxUrl.replaceAll(RMI_HOST_REGEX, "://" + hostName);
    }

    private boolean isConnected() {
        return this.zooKeeper != null && this.zooKeeper.isConnected();
    }

    public void configurationEvent(ConfigurationEvent event) {
        try {
            if (this.zooKeeper.isConnected()) {
                String jmxUrl;
                String sshUrl;
                String name = System.getProperty("karaf.name");
                if (event.getPid().equals("org.apache.karaf.shell") && event.getType() == 1 && (sshUrl = this.getSshUrl()) != null) {
                    this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_SSH.getPath(name), this.getSshUrl(), CreateMode.PERSISTENT);
                }
                if (event.getPid().equals("org.apache.karaf.management") && event.getType() == 1 && (jmxUrl = this.getJmxUrl()) != null) {
                    this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_JMX.getPath(name), this.getJmxUrl(), CreateMode.PERSISTENT);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

