/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.spring;

import java.io.File;
import java.net.InetSocketAddress;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ZKServerFactoryBean
implements FactoryBean<ZooKeeperServer>,
InitializingBean,
DisposableBean {
    private ZooKeeperServer zooKeeperServer = new ZooKeeperServer();
    private NIOServerCnxn.Factory connectionFactory;
    private File dataLogDir;
    private File dataDir;
    protected int tickTime = 3000;
    private int minSessionTimeout = -1;
    private int maxSessionTimeout = -1;
    private InetSocketAddress clientPortAddress;
    private int maxClientConnections;
    private int port = 2181;

    public ZooKeeperServer getObject() throws Exception {
        return this.zooKeeperServer;
    }

    public Class<ZooKeeperServer> getObjectType() {
        return ZooKeeperServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        FileTxnSnapLog ftxn = new FileTxnSnapLog(this.getDataLogDir(), this.getDataDir());
        this.zooKeeperServer.setTxnLogFactory(ftxn);
        this.zooKeeperServer.setTickTime(this.getTickTime());
        this.zooKeeperServer.setMinSessionTimeout(this.getMinSessionTimeout());
        this.zooKeeperServer.setMaxSessionTimeout(this.getMaxSessionTimeout());
        this.connectionFactory = new NIOServerCnxn.Factory(this.getClientPortAddress(), this.getMaxClientConnections());
        this.connectionFactory.startup(this.zooKeeperServer);
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    protected void shutdown() {
        if (this.connectionFactory != null) {
            this.connectionFactory.shutdown();
            this.connectionFactory = null;
        }
    }

    public ZooKeeperServer getZooKeeperServer() {
        return this.zooKeeperServer;
    }

    public NIOServerCnxn.Factory getConnectionFactory() {
        return this.connectionFactory;
    }

    public File getDataLogDir() {
        if (this.dataLogDir == null) {
            this.dataLogDir = new File(this.getZKOutputDir(), "log");
            this.dataLogDir.mkdirs();
        }
        return this.dataLogDir;
    }

    public File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = new File(this.getZKOutputDir(), "data");
            this.dataDir.mkdirs();
        }
        return this.dataDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public InetSocketAddress getClientPortAddress() {
        if (this.clientPortAddress == null) {
            this.clientPortAddress = new InetSocketAddress(this.port);
        }
        return this.clientPortAddress;
    }

    public int getMaxClientConnections() {
        return this.maxClientConnections;
    }

    public void setClientPortAddress(InetSocketAddress clientPortAddress) {
        this.clientPortAddress = clientPortAddress;
    }

    public void setConnectionFactory(NIOServerCnxn.Factory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setDataLogDir(File dataLogDir) {
        this.dataLogDir = dataLogDir;
    }

    public void setMaxClientConnections(int maxClientConnections) {
        this.maxClientConnections = maxClientConnections;
    }

    public void setMaxSessionTimeout(int maxSessionTimeout) {
        this.maxSessionTimeout = maxSessionTimeout;
    }

    public void setMinSessionTimeout(int minSessionTimeout) {
        this.minSessionTimeout = minSessionTimeout;
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    public void setZooKeeperServer(ZooKeeperServer zooKeeperServer) {
        this.zooKeeperServer = zooKeeperServer;
    }

    protected File getZKOutputDir() {
        String baseDir = System.getProperty("basedir", ".");
        File dir = new File(baseDir + "/target/zk");
        dir.mkdirs();
        return dir;
    }
}

