/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import java.nio.charset.Charset;
import java.util.List;
import jline.Terminal;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.commands.support.ZookeeperContentManager;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;
import org.jledit.ConsoleEditor;
import org.jledit.ContentManager;
import org.jledit.EditorFactory;

@Command(name="edit", scope="zk", description="Edits a znode's data", detailedDescription="classpath:edit.txt")
public class Edit
extends ZooKeeperCommandSupport {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @Argument(description="Path of the znode to get")
    String path;
    private EditorFactory editorFactory;

    @Override
    protected void doExecute(IZKClient zk) throws Exception {
        if (zk.exists(this.path) == null) {
            zk.createWithParents(this.path, "", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        ConsoleEditor editor = this.editorFactory.create(this.getTerminal());
        editor.setTitle("Znode");
        editor.setContentManager((ContentManager)new ZookeeperContentManager(zk));
        editor.open(this.path);
        editor.setOpenEnabled(false);
        editor.start();
    }

    private Terminal getTerminal() throws Exception {
        Object terminalObject = this.session.get(".jline.terminal");
        if (terminalObject instanceof Terminal) {
            return (Terminal)terminalObject;
        }
        throw new IllegalStateException("Could not get Terminal from CommandSession.");
    }

    public EditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorFactory(EditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }
}

