/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.commands.ZooKeeperCommandSupport;

@Command(name="delete", scope="zk", description="Delete the specified znode", detailedDescription="classpath:delete.txt")
public class Delete
extends ZooKeeperCommandSupport {
    @Option(name="-v", aliases={"--version "}, description="The ZooKeeper version to delete. By default, delete all versions.")
    int version = -1;
    @Option(name="-r", aliases={"--recursive"}, description="Recursively delete children.")
    boolean recursive;
    @Argument(description="Path of the znode to delete")
    String path;

    @Override
    protected void doExecute(IZKClient zk) throws Exception {
        if (this.recursive) {
            if (this.version >= 0) {
                throw new UnsupportedOperationException("Unable to delete a version recursively");
            }
            zk.deleteWithChildren(this.path);
        } else {
            zk.delete(this.path, this.version);
        }
    }
}

